/********** CalibrationChannelNoiseRecord.C ********************************************************************************\

 $Header$

 REVISION HISTORY
   05/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#include "CalibrationChannelNoiseRecord.h"
#include <memory.h>
#include "DiagnosticReporter.h"

extern diagnostic_reporter diagnosticreporter;

calibration_channel_noise_record :: calibration_channel_noise_record ()
{
  for ( int pixel = 0; pixel < CALIBRATION_PIXELS; pixel++ )
    for ( int state = 0; state < POSITION_NOISE_STATES; state++ )
      for ( int position = 0; position < CALIBRATION_PACKETPOSITION; position++ ) 
        positionnoise [pixel] [state] [position] = CALIBRATION_MISSING_VALUE;
}


calibration_channel_noise_record :: ~calibration_channel_noise_record ()
{
  ;
}


void calibration_channel_noise_record :: AddPosNoise ( int pos, int pixel, 
						       enum position_noise_state_offset state, float posnoise ) 
{
  positionnoise [pixel] [state] [pos] = posnoise ;
}


void calibration_channel_noise_record :: GetData ( float noisedata [CALIBRATION_PIXELS] [POSITION_NOISE_STATES]
				                   [CALIBRATION_PACKETPOSITION] )
{
  (void) memcpy ((void*) noisedata, (const void*) positionnoise,
                 sizeof (float [CALIBRATION_PIXELS] [POSITION_NOISE_STATES][CALIBRATION_PACKETPOSITION] ));  
}
