/********** CalibrationChannelLMCSolarHistory.C ***********************************************************************\

 $Header$

 REVISION HISTORY
   11/00   Charles Cavanaugh

 $Log$

\**********************************************************************************************************************/

#include <iomanip>
#include <math.h>
#include "CalibrationChannelLMCSolarHistory.h"

calibration_channel_lmc_solar_history :: calibration_channel_lmc_solar_history ()
                                       : calibration_channel_lmc_history ()
{
  ;
}


calibration_channel_lmc_solar_history :: calibration_channel_lmc_solar_history (int channel)
                                       : calibration_channel_lmc_history (channel)
{
  ;
}


calibration_channel_lmc_solar_history :: ~calibration_channel_lmc_solar_history ()
{
  ;
}


void calibration_channel_lmc_solar_history :: ReadCurrentGranuleGains (PGSt_PC_Logical filelogical,
                                                                       enum science_train_data_type datatype,
                                                                       science_train_group* traingroup, 
                                                                       mopir_collection const& mopircollection)
{
  calibration_channel_record* gainrecord = NULL;

  // activate the MOPCH train group
  if (ActivateTrainGroup (filelogical, datatype, traingroup)) {

    // for each "datatype" record
    for (int index = 0; index < traingroup->GetEventCount (datatype); index++)
      if (traingroup->GetRecord (index, datatype, internalrecord)) {

        // get the closest cold record
        if (traingroup->GetClosestShadowedRecord (internalrecord->GetStartTime (), COLD_DATA_TYPE, spacerecord)) {

          // make a new gain record, fill it and add it to the gain list
          gainrecord = new calibration_channel_record (internalrecord->GetStartTime ());
          FillGainRecord (mopircollection, datatype, gainrecord);
          gainlist.AddRecord (gainrecord);
        }
     }

    // inactive the MOPCH train group
    InactivateTrainGroup (traingroup);
  }
}


void calibration_channel_lmc_solar_history :: ReadCurrentGranuleOffsets (PGSt_PC_Logical filelogical, 
                                                                         enum science_train_data_type datatype,
                                                                         science_train_group* traingroup)
{
  calibration_channel_record* offsetrecord = NULL;

  // activate the MOPCH train group
  if (ActivateTrainGroup (filelogical, COLD_DATA_TYPE, traingroup)) {

    // for each record
    for (int index = 0; index < traingroup->GetShadowedEventCount (COLD_DATA_TYPE); index++)
      if (traingroup->GetShadowedRecord (index, COLD_DATA_TYPE, spacerecord)) {

        // make a new offset record, fill it and add it to the offset list
        offsetrecord = new calibration_channel_record (spacerecord->GetStartTime ());
        FillOffsetRecord (datatype, offsetrecord);
        offsetlist.AddRecord (offsetrecord);
      }

    // inactive the MOPCH train group
    InactivateTrainGroup (traingroup);
  }
}


void calibration_channel_lmc_solar_history :: ReadPostGranuleGains (PGSt_PC_Logical filelogical,
                                                                    enum science_train_data_type datatype,
                                                                    science_train_group* traingroup, 
								    mopir_collection const& mopircollection)
{
  // activate the MOPCH train group
  if (ActivateTrainGroup (filelogical, datatype, traingroup)) {

    // get count of "datatype" events
    int events = traingroup->GetEventCount (datatype);

    // get the first "datatype" record
    if (events > 0)
      if (traingroup->GetRecord (0, datatype, internalrecord))

        // get the closest cold record
        if (traingroup->GetClosestShadowedRecord (internalrecord->GetStartTime (), COLD_DATA_TYPE, spacerecord)) {

          // make a new gain record, fill it and add it to the gain list
          calibration_channel_record* gainrecord = new calibration_channel_record (internalrecord->GetStartTime ());
          FillGainRecord (mopircollection, datatype, gainrecord);
          gainlist.AddRecord (gainrecord);
        }

    // repeat for second record (we want two gain records because the gain will be interpolated to the offset time)
    if (events > 1)
      if (traingroup->GetRecord (1, datatype, internalrecord))

        // get the closest cold record
        if (traingroup->GetClosestShadowedRecord (internalrecord->GetStartTime (), COLD_DATA_TYPE, spacerecord)) {

          // make a new gain record, fill it and add it to the gain list
          calibration_channel_record* gainrecord = new calibration_channel_record (internalrecord->GetStartTime ());
          FillGainRecord (mopircollection, datatype, gainrecord);
          gainlist.AddRecord (gainrecord);
        }

    // inactive the MOPCH train group
    InactivateTrainGroup (traingroup);
  }
}


void calibration_channel_lmc_solar_history :: ReadPostGranuleOffsets (PGSt_PC_Logical filelogical, 
                                                                      enum science_train_data_type datatype,
                                                                      science_train_group* traingroup)
{
  // activate the MOPCH train group
  if (ActivateTrainGroup (filelogical, COLD_DATA_TYPE, traingroup)) {

    // get count of cold events
    int events = traingroup->GetShadowedEventCount (COLD_DATA_TYPE);

    // get the first cold record
    if (events > 0)
      if (traingroup->GetShadowedRecord (0, COLD_DATA_TYPE, spacerecord)) {

        // make a new offset record, fill it and add it to the offset list
        calibration_channel_record* offsetrecord = new calibration_channel_record (spacerecord->GetStartTime ());
        FillOffsetRecord (datatype, offsetrecord);
        offsetlist.AddRecord (offsetrecord);
      }

    // inactive the MOPCH train group
    InactivateTrainGroup (traingroup);
  }
}


void calibration_channel_lmc_solar_history :: ReadPreGranuleGains (PGSt_PC_Logical filelogical,
                                                                   enum science_train_data_type datatype,
                                                                   science_train_group* traingroup, 
								   mopir_collection const& mopircollection)
{
  calibration_channel_record* gainrecord = NULL;

  // activate the MOPCH train group
  if (ActivateTrainGroup (filelogical, datatype, traingroup)) {

    // get count of "datatype" events
    int events = traingroup->GetEventCount (datatype);

    // get the penultimate "datatype" record
    if (events > 1) 
      if (traingroup->GetRecord ((events - 2), datatype, internalrecord))

        // get the closest cold record
        if (traingroup->GetClosestShadowedRecord (internalrecord->GetStartTime (), COLD_DATA_TYPE, spacerecord)) {

          // make a new gain record, fill it and add it to the gain list
          gainrecord = new calibration_channel_record (internalrecord->GetStartTime ());
          FillGainRecord (mopircollection, datatype, gainrecord);
          gainlist.AddRecord (gainrecord);
        }

    // repeat for ultimate record (we want two gain records because the gain will be interpolated to the offset time)
    if (events > 0) 
      if (traingroup->GetRecord ((events - 1), datatype, internalrecord))

        // get the closest cold record
        if (traingroup->GetClosestShadowedRecord (internalrecord->GetStartTime (), COLD_DATA_TYPE, spacerecord)) {

          // make a new gain record, fill it and add it to the gain list
          gainrecord = new calibration_channel_record (internalrecord->GetStartTime ());
          FillGainRecord (mopircollection, datatype, gainrecord);
          gainlist.AddRecord (gainrecord);
        }

    // inactive the MOPCH train group
    InactivateTrainGroup (traingroup);
  }
}


void calibration_channel_lmc_solar_history :: ReadPreGranuleOffsets (PGSt_PC_Logical filelogical, 
                                                                     enum science_train_data_type datatype,
                                                                     science_train_group* traingroup)
{
  // activate the MOPCH train group
  if (ActivateTrainGroup (filelogical, COLD_DATA_TYPE, traingroup)) {

    // get count of cold events
    int events = traingroup->GetShadowedEventCount (COLD_DATA_TYPE);

    // get the last cold record
    if (events > 0)
      if (traingroup->GetShadowedRecord ((events - 1), COLD_DATA_TYPE, spacerecord)) {

        // make a new offset record, fill it and add it to the offset list
        calibration_channel_record* offsetrecord = new calibration_channel_record (spacerecord->GetStartTime ());
        FillOffsetRecord (datatype, offsetrecord);
        offsetlist.AddRecord (offsetrecord);
      }

    // inactive the MOPCH train group
    InactivateTrainGroup (traingroup);
  }
}
