/********** CalibrationChannelHistory.h *******************************************************************************\

 $Header$

 REVISION HISTORY
   06/99   Charles Cavanaugh
   11/99   Charles Cavanaugh
   09/00   Charles Cavanaugh
   11/00   Charles Cavanaugh
   10/01   Debbie Mao
   04/02   Debbie Mao
   05/02   Debbie Mao
   06/02   Debbie Mao

 $Log$

\**********************************************************************************************************************/

#if !defined _MOPITT_L1_CALIBRATION_CHANNEL_HISTORY_

  #define _MOPITT_L1_CALIBRATION_CHANNEL_HISTORY_

  #include "ScienceCalibrationRecord.h"
  #include "ScienceTrainGroup.h"
  #include "CalibrationRecordList.h"
  #include "CalibrationNoiseRecordList.h"
  #include "MOPCHReadFile.h"
  #include "MOPIRCollection.h"

  class calibration_channel_history {
    private :

    protected :
      static int const INTERPOLATION_WARNING;

      bool ActivateTrainGroup    (PGSt_PC_Logical, enum science_train_data_type, science_train_group*);
      bool InactivateTrainGroup  (science_train_group*);
      void InterpolateTrackData  (mopitt_time const&, calibration_channel_record*, calibration_channel_record*,
                                  float [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS],
				  double [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES]);
      void InvalidateOffsetData  (calibration_channel_record*);
      static float const NOISEVALUES [CALIBRATION_CHANNELS] [CALIBRATION_STATES];

      int                                channel;
      science_calibration_record*        internalrecord;
      science_calibration_record*        spacerecord;
      calibration_record_list            gainlist;
      calibration_record_list            offsetlist;
      mopch_read_file*                   mopchfile;
      calibration_noise_record_list      noiselist;
      
      void         CalculateGain             (float, float, double, double, double, double, float&, float&) const;
      void         CalculateNoise            (float, float, double, float&, float&) const;
      void         CalculateOffset           (float, float, double, double, float&, float&) const;
      void         CalculatePosNoise         (float, double, float&) const;
      virtual void FillGainRecord            (mopir_collection const&, enum science_train_data_type, 
                                              calibration_channel_record*) {;}
      virtual void FillGainRecord            (mopir_collection const&, enum science_train_data_type, 
                                              calibration_channel_record*, calibration_channel_noise_record* ){;} 
      void         FillOffsetRecord          (enum science_train_data_type, calibration_channel_record*);
      void         GetBracketingRecords      (mopitt_time const&, calibration_record_list&, 
                                              calibration_channel_record**, calibration_channel_record**);
      void         InterpolateDataPoints     (float, float, float, float, mopitt_time const&, mopitt_time const&, 
                                              mopitt_time const&, float&, float&);
      virtual void InterpolateOffsetData     (calibration_channel_record*, calibration_channel_record*, 
                                              calibration_channel_record*) {;}
      virtual void InterpolateOffsetData     (calibration_channel_record*, calibration_channel_record*, 
                                              enum science_train_data_type, calibration_channel_record*) {;}
      virtual void ReadCurrentGranuleGains   (PGSt_PC_Logical, enum science_train_data_type, science_train_group*, 
                                              mopir_collection const&);
      virtual void ReadCurrentGranuleOffsets (PGSt_PC_Logical, enum science_train_data_type, science_train_group*);
      virtual void ReadPostGranuleGains      (PGSt_PC_Logical, enum science_train_data_type, science_train_group*, 
                                              mopir_collection const&);
      virtual void ReadPostGranuleOffsets    (PGSt_PC_Logical, enum science_train_data_type, science_train_group*);
      virtual void ReadPreGranuleGains       (PGSt_PC_Logical, enum science_train_data_type, science_train_group*, 
                                              mopir_collection const&);
      virtual void ReadPreGranuleOffsets     (PGSt_PC_Logical, enum science_train_data_type, science_train_group*);
      virtual void TransferOffsetData        (calibration_channel_record*, calibration_channel_record*) {;}
      virtual void TransferOffsetData        (calibration_channel_record*, enum science_train_data_type, 
                                              calibration_channel_record*) {;}

    public :
      calibration_channel_history ();
      calibration_channel_history (int);
      virtual ~calibration_channel_history () = 0;

      virtual void GetBracketingTimes    (mopitt_time const&, mopitt_time&, mopitt_time&) {;}
      void         Read                  (PGSt_PC_Logical, PGSt_PC_Logical, PGSt_PC_Logical, PGSt_PC_Logical, 
                                          PGSt_PC_Logical, enum science_train_data_type, science_train_group*, 
                                          mopir_collection const&, processor_parameters const&);

      bool GetTrackData (mopitt_time const&, 
                    float  [CALIBRATION_PIXELS] [CALIBRATION_STATES] [CALIBRATION_TERMS],
	            double [CALIBRATION_PACKETPOSITION] [CALIBRATION_PIXELS] [PMC_SIGNAL_STATES]);
      void GetNoiseData (float [CALIBRATION_PIXELS][POSITION_NOISE_STATES][CALIBRATION_PACKETPOSITION] );

  };

#endif
