/********** TimeSetNCAR.C *********************************************************************************************\

 !C

 $Header$

 PURPOSE
   Sets the fields in an ncar_time container

 INPUT ARGUMENTS
   ncarday     int   The value to set in the day field
   ncarmsecs   int   The value to set in the msecs field

 INPUT/OUTPUT ARGUMENTS
   None

 OUTPUT ARGUMENTS
   ncartime   ncar_time*   The address of the container to fill

 RETURNS
   None

 ASSUMPTIONS ON ENTRY
   FILES
     None
   MISCELLANEOUS
     The ncartime address is valid

 ASSUMPTIONS ON EXIT
   FILES
     None
   ERROR HANDLING
     Errors are handled via the SMF
   MISCELLANEOUS
     None

 ADDITIONAL COMMENTS
   None

 ORIGINAL VERSION
   01/23/98  Charles Cavanaugh

 MODIFIED VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/

#include "Time.h"

void TimeSetNCAR (int ncarday, int ncarmsecs, ncar_time *ncartime)
{
  ncartime->day = ncarday;
  ncartime->msecs = ncarmsecs;
}
