/********** TimeGetNCAR.C *********************************************************************************************\

 !C

 $Header$

 PURPOSE
   Retrieves the fields from a ncar_time container

 INPUT ARGUMENTS
   ncartime   const ncar_time*   The address of the container from which to retrieve the fields

 INPUT/OUTPUT ARGUMENTS
   None

 OUTPUT ARGUMENTS
   ncarday     int*   The container in which to put the day
   ncarmsecs   int*   The container in which to put the milliseconds

 RETURNS
   None

 ASSUMPTIONS ON ENTRY
   FILES
     None
   MISCELLANEOUS
     The addresses are valid and ncartime contains valid data

 ASSUMPTIONS ON EXIT
   FILES
     None
   ERROR HANDLING
     Errors are handled via the SMF
   MISCELLANEOUS
     None

 ADDITIONAL COMMENTS
   None

 ORIGINAL VERSION
   01/23/98  Charles Cavanaugh

 MODIFIED VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/

#include "Time.h"

void TimeGetNCAR (const ncar_time *ncartime, int *ncarday, int *ncarmsecs)
{
  *ncarday = ncartime->day;
  *ncarmsecs = ncartime->msecs;
}
