/********** TimeConvertUTCToTAI.C *************************************************************************************\

 !C

 $Header$

 PURPOSE
   To convert a UTC-form time to a TAI-form time

 INPUT ARGUMENTS
   utctime   const utc_string   The UTC-format time container

 INPUT/OUTPUT ARGUMENTS
   None

 OUTPUT ARGUMENTS
   taitime   double*   The address of the TAI-format time container

 RETURNS
   ON SUCCESS
     SYSTEM_SUCCESS
   ON FAILURE
     SYSTEM_FAILURE

 ASSUMPTIONS ON ENTRY
   FILES
     None
   MISCELLANEOUS
     The taitime address is valid

 ASSUMPTIONS ON EXIT
   FILES
     None
   Error Handling
     Errors are handled via the SMF
   MISCELLANEOUS
     None

 ORIGINAL VERSION
   07/23/96  Charles Cavanaugh

 MODIFIED VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/

#include "PGS_SMF.h"
#include "PGS_TD.h"
#include "Time.h"
#include "System.h"

system_code TimeConvertUTCToTAI (const utc_string utctime, double *taitime)
{
  system_code returncode = SYSTEM_SUCCESS;    // Return value indicating (un)successful operation.
  PGSt_SMF_status smfcode;
  PGSt_double timetai;

  /*** call the toolkit function to convert UTC time format to TAI format ***/
  smfcode = PGS_TD_UTCtoTAI ((char *) utctime, &timetai);
  *taitime = (double) timetai;

  /*** SUCCESS and PRED_LEAPS are OK, but anything else suggests an error ***/
  if (smfcode != PGS_S_SUCCESS && smfcode != PGSTD_W_PRED_LEAPS)
    returncode = SYSTEM_FAILURE;

  return returncode;
}
