/********** TimeConvertPacketToNCAR.C *********************************************************************************\
 
 !C
 
 $Header$
 
 PURPOSE
   Converts the time field in a packet to NCAR-form time.
 
 INPUT ARGUMENTS
   timeptr   const PGSt_IO_L0_Packet*   The address of the packet-format time container
 
 INPUT/OUTPUT ARGUMENTS
   None
 
 OUTPUT ARGUMENTS
   ncartime   ncar_time*   The address of the NCAR-format time container

 RETURNS
   None
 
 ASSUMPTIONS ON ENTRY
   FILES
     None
   MISCELLANEOUS
     SCTIME_BYTES is at least 6
     The timeptr and ncartime addresses are valid
 
 ASSUMPTIONS ON EXIT
   FILES
     None
   ERROR HANDLING
     Errors are handled via the SMF
   MISCELLANEOUS
     None
 
 ADDITIONAL COMMENTS
   None
 
 ORIGINAL VERSION
   07/23/96  Charles Cavanaugh

 MODIFIED VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/

#include "PGS_TD.h"
#include "PGS_IO_L0.h"
#include "Time.h"

void TimeConvertPacketToNCAR (const PGSt_IO_L0_Packet *timeptr, ncar_time *ncartime)
{
  int scbyte;
  PGSt_scTime sctime [SCTIME_BYTES];

  /*** move the time info from the packet data into the sctime format;  ***
   *** some header flag shares the MSB of the day, so mask out the flag ***/
  for (scbyte = 0; scbyte < SCTIME_BYTES; scbyte++) 
    sctime[scbyte] = (PGSt_scTime) *(timeptr + scbyte);
  sctime[0] &= (PGSt_scTime) 0x7F;

  /*** convert day bytes and msec bytes ***/
  ncartime->day = (sctime[0] * 256) + (int) sctime[1];
  ncartime->msecs = (sctime[2] * 16777216) + (sctime[3] * 65536) + (sctime[4] * 256) + (int) sctime[5];
}
