/********** Time.h ****************************************************************************************************\

 !C

 $Header$

 PURPOSE
   Time definitions.

 ORIGINAL VERSION
   07/31/97  Charles Cavanaugh

 MODIFIED VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/

#ifndef MOPITT_TIME_H

  #define MOPITT_TIME_H

  #include "PGS_IO_L0.h"
  #include "System.h"

  #define SCTIME_BYTES     8    // Number of bytes in spacecraft time.
  #define UTC_SIZE         28   // Number of characters in a UTC-format time string.

  // UTC time string.
  typedef char utc_string [UTC_SIZE];

  // NCAR time structure.
  typedef struct ncar_time {
     int day;
     int msecs;
  } ncar_time;

  // Time function definitions.
  void TimeConvertPacketToNCAR (const PGSt_IO_L0_Packet*, ncar_time*);
  void TimeGetNCAR (const ncar_time*, int*, int*);
  void TimeSetNCAR (int, int, ncar_time*);
  system_code TimeConvertNCARToTAI (const ncar_time*, double*);
  system_code TimeConvertUTCToTAI (const utc_string, double*);
  
#endif
