/********* ScienceWritePacketHeader.C *****************************************************************************************\

 !C

 $Header$

 PURPOSE
   Writes the packet header to the output file.

 INPUT ARGUMENTS
   const science_packet *sciencepacket      Pointer to the file packet.

 INPUT/OUTPUT ARGUMENTS
   FILE *outhandle                          Handle for the output file.

 OUTPUT ARGUMENTS
   None

 RETURNS
   ON SUCCESS
     SYSTEM_SUCCESS
   ON FAILURE
     SYSTEM_FAILURE

 ASSUMPTIONS ON ENTRY
   The science packet address and output handle are valid

 ASSUMPTIONS ON EXIT
   The packet header has been written to the output file.

 ORIGINAL VERSION
   09/25/97  Charles Cavanaugh

 MODIFIED VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/

#include <stdio.h>         // sprintf(), fwrite();
#include "Science.h"
#include "System.h"
#include "Message.h"

system_code ScienceWritePacketHeader (const science_packet *sciencepacket, FILE* outhandle, long packetnumber)
{
  system_code returncode = SYSTEM_SUCCESS;   // Return value indicating (un)successful operation.
  char message[280];                         // A warning or error message to be sent to the LogReport
                                             //  file and/or screen.

  // Write the packet header to the output file, checking for error.
  if (fwrite(sciencepacket->data, 1, CCSDS_HEADER_SIZE, outhandle) != CCSDS_HEADER_SIZE) {
    // Generate message.
    sprintf(message, 
	    "Could not write CCSDS header for packet # %ld which begins at byte offset %ld to the output file.", 
	    packetnumber, (packetnumber - 1) * SCI_PACKET_SIZE);
    MessageOut(message);
    returncode = SYSTEM_FAILURE;
  }

  return returncode;
}
