/********* ScienceWriteDummyPacket.C *****************************************************************************************\

 !C

 $Header$

 PURPOSE
   Writes a dummy packet to the output file.

 INPUT ARGUMENTS
   long packetnumber                   The packet's position within the entire file, with 1 being the first packet, etc.

 INPUT/OUTPUT ARGUMENTS
   FILE* outhandle                     A handle to the output file.

 OUTPUT ARGUMENTS
   None

 RETURNS
   ON SUCCESS
     SYSTEM_SUCCESS
   ON FAILURE
     SYSTEM_FAILURE

 ASSUMPTIONS ON ENTRY
   The handle to the output file is correct.
   The packet number is valid.

 ASSUMPTIONS ON EXIT
   The dummy packet has been written to the output file.

 ORIGINAL VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/

#include <stdio.h>       // fputc(), ferror(), sprintf().
#include "Science.h"
#include "System.h"
#include "Message.h"

system_code ScienceWriteDummyPacket (FILE* outhandle, long packetnumber)
{
  system_code returncode = SYSTEM_SUCCESS;   // Return value indicating (un)successful operation.
  int bytenumber;                            // Index for a byte being written to the output file.
  char message[280];                         // A warning or error message to be sent to the LogReport
                                             //  file and/or screen.

  // Write the dummy packet with the necessary CCSDS header info to the output file, checking for error.
  fputc(0x08, outhandle);
  if (!ferror(outhandle)) {
    fputc(0xc0, outhandle);
    if (!ferror(outhandle)) {
      fputc(0x00, outhandle);
      if (!ferror(outhandle)) {
	fputc(0x00, outhandle);
	if (!ferror(outhandle)) {
	  fputc(0x19, outhandle);
	  if (!ferror(outhandle)) {
	    fputc(0xd1, outhandle);
	    if (!ferror(outhandle)) {
	      fputc(0x39, outhandle);
	      if (!ferror(outhandle)) {
		fputc(0xe3, outhandle);
                // Fill the remaining bytes with zeros.
		for (bytenumber = 1; bytenumber < SCI_PACKET_SIZE; bytenumber++)
	          if (!ferror(outhandle)) 
		    fputc(0x00, outhandle);
	      }
	    }
	  }
	}
      }
    }
  }

  if (ferror(outhandle)) {
    // Generate message.
    sprintf(message, 
	    "Could not write dummy packet # %ld which begins at byte offset %ld to the output file.", 
	    packetnumber, (packetnumber - 1) * SCI_PACKET_SIZE);
    MessageOut(message);
    returncode = SYSTEM_FAILURE;
  }

  return returncode;
}
