/********** ScienceOpenFiles.C *********************************************************************************************\

 !C++

 $Header$

 PURPOSE
   Opens the level 0 input and output files.

 INPUT ARGUMENTS
   PGSt_PC_Logical infilelogical         File logical for input file

 INPUT/OUTPUT ARGUMENTS
   science_inhandle *inhandle            Handle for input file.
   FILE** outhandle                      Pointer to handle for output file.

 OUTPUT ARGUMENTS
   None

 RETURNS
   ON SUCCESS  
     SYSTEM_SUCCESS
   ON FAILURE
     SYSTEM_FAILURE

 ASSUMPTIONS ON ENTRY
   The PGE PCF has staged all required files.
   The file logicals and file handles are correct.

 ASSUMPTIONS ON EXIT
   The input file has been opened for read and the output file has been opened for write.

 ORIGINAL VERSION
   5/99   Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/
#include "Science.h"
#include "Message.h"
#include "System.h"
#include "PGS_PC.h"
#include <stdio.h>
#include "PGS_SMF.h"

system_code ScienceOpenFiles(PGSt_PC_Logical infilelogical, science_inhandle *inhandle, FILE** outhandle)
{
  system_code returncode = SYSTEM_SUCCESS;   // Return value indicating (un)successful operation.
  PGSt_double starttime, stoptime;           // Start/stop times for input file (not used but required by toolkit).
  char outputfilename[80];    
  PGSt_IO_L0_VirtualDataSet id;               
  PGSt_SMF_status returnStatus;
  PGSt_integer version = 1;
  char filename [PGSd_PC_FILE_PATH_MAX];

  PGSt_SMF_code code;
  char mnemonic[PGS_SMF_MAX_MNEMONIC_SIZE];
  char msg[PGS_SMF_MAX_MSGBUF_SIZE];

  // Initialize the input file handle's eoiflag to not eoi.
  inhandle->eoiflag = SYSTEM_FALSE;

  // Call the toolkit function to open the input file, checking for error.
  returnStatus = PGS_PC_GetReference (infilelogical, &version, filename);
  if ( returnStatus != PGS_S_SUCCESS) 
    MessageOut("Could not get file reference!");
  else 
    MessageOut(filename);

  if (PGS_IO_L0_Open (infilelogical, PGSd_EOS_AM, &id, &starttime, &stoptime) != PGS_S_SUCCESS) {
    // Generate message.
    PGS_SMF_GetMsg (&code, mnemonic, msg);
    MessageOut(msg);
    MessageOut("Could not open input file.");
    printf("%d\n", id);
    printf("%g\n", starttime);
    printf("%g\n", stoptime);
    returncode = SYSTEM_FAILURE;
  }
  else {
    // Open the output file for write.
    sprintf (outputfilename, "%i.remapped", (int) infilelogical);
    inhandle->id = id;
    if ((*outhandle = fopen (outputfilename, "w")) == NULL) {
      // Generate message.
      MessageOut("Could not open output file.");
      returncode = SYSTEM_FAILURE;
    }
  }
  return returncode;
}
