/********** ScienceCloseFiles.C *********************************************************************************************\

 !C++

 $Header$

 PURPOSE
   Closes the level 0 input and output files.

 INPUT ARGUMENTS
   science_inhandle *inhandle          Input file handle. 
   FILE** outhandle                    Pointer to output file handle.

 INPUT/OUTPUT ARGUMENTS
   None

 OUTPUT ARGUMENTS
   None

 RETURNS
   ON SUCCESS   
     SYSTEM_SUCCESS
   ON FAILURE
     SYSTEM_FAILURE

 ASSUMPTIONS ON ENTRY
     The input and output files are open.

 ASSUMPTIONS ON EXIT
     The input and output files have been closed.

 ORIGINAL VERSION
   5/99   Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/
#include "PGS_IO.h"
#include "Science.h" 
#include "System.h"
#include "Message.h"

system_code ScienceCloseFiles (science_inhandle *inhandle, FILE **outhandle)
{
  system_code returncode = SYSTEM_SUCCESS;   // Return value indicating (un)successful operation.

  // Close the output file.
  if ((fclose (*outhandle)) == EOF) {
    // Generate message.
    MessageOut("Could not close output file.");
    returncode = SYSTEM_FAILURE;
  }

  // Call the toolkit function to close the input file.
  if (PGS_IO_L0_Close (inhandle->id) != PGS_S_SUCCESS) {
    // Generate message.
    MessageOut("Could not close input file.");
    returncode = SYSTEM_FAILURE;
  }
  return returncode;
}
