/********** Science.h *************************************************************************************************\

 !C

 $Header$

 PURPOSE
   Science definitions.

 ORIGINAL VERSION
   08/05/95  Charles Cavanaugh

 MODIFIED VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/

#ifndef MOPITT_SCIENCE_H

  #define MOPITT_SCIENCE_H

  #include "PGS_IO.h"
  #include "Time.h"
  #include "System.h"

  #define LMC_CHANNEL_SIZE         198        // Number of bytes in an lmc channel.
  #define LMC_CHANNELS             6          // Number of lmc channels.                   
  #define PMC_CHANNEL_SIZE         54         // Number of bytes in a pmc channel.         
  #define PMC_CHANNELS             2          // Number of pmc channels.                   
  #define STARE_HEADER_SIZE        24         // Number of bytes in a stare header.        
  #define STARES_PER_PACKET        5          // Number of stares in a science packet.     
  #define CCSDS_HEADER_SIZE        16         // Number of bytes in the CCSDS header.      

  // Number of bytes in one science stare.
  #define STARE_SIZE   ((LMC_CHANNEL_SIZE * LMC_CHANNELS) + (PMC_CHANNEL_SIZE * PMC_CHANNELS) + STARE_HEADER_SIZE)

  // Number of bytes in one science packet.
  #define SCI_PACKET_SIZE   ((STARE_SIZE * STARES_PER_PACKET) + CCSDS_HEADER_SIZE)

  #define PACKET_TIME_OFFSET         6        // Packet time byte offset within a packet header.

  // Byte offsets for most significant and least significant bytes of the stare time in the stare header.
  #define STARETIME_MSW_MSB_OFFSET   6        
  #define STARETIME_MSW_LSB_OFFSET   7
  #define STARETIME_LSW_MSB_OFFSET   4
  #define STARETIME_LSW_LSB_OFFSET   5

  // Science input file handle structure functions.
  #define SciencePacketsPresent(handle) ((handle)->eoiflag == SYSTEM_TRUE ? SYSTEM_FALSE : SYSTEM_TRUE) 
  #define ScienceSetInputFlag(handle) ((handle)->eoiflag = SYSTEM_TRUE)
  #define ScienceFileID(handle) ((handle)->id)

  // Byte offsets for elements of a stare header.
  #define ID_OFFSET             0
  #define BITMASK_OFFSET        1
  #define WORDCOUNT_OFFSET      2
  #define TIME_OFFSET           4
  #define DMA_OFFSET            8
  #define MIRROR_INFO_OFFSET   12

  // Byte sizes for elements of a stare header. 
  #define ID_SIZE               1
  #define BITMASK_SIZE          1
  #define WORDCOUNT_SIZE        2
  #define TIME_SIZE             4
  #define DMA_SIZE              4
  #define MIRROR_INFO_SIZE     12

  // Science input file handle structure.
  typedef struct science_inhandle {
     PGSt_IO_L0_VirtualDataSet id;
     system_boolean            eoiflag;
  } science_inhandle;

  // Science packet handle structure.
  typedef struct science_packet {
     ncar_time         time;
     PGSt_IO_L0_Packet data [SCI_PACKET_SIZE];
  } science_packet;

  // Science function definitions.
  system_code ScienceOpenFiles (PGSt_PC_Logical, science_inhandle*, FILE**);
  system_code ScienceCloseFiles (science_inhandle*, FILE**); 
  system_code ScienceGetPacket (science_inhandle*, science_packet*);
  system_code ScienceWriteDummyPacket(FILE*, long);
  system_code ScienceWritePacketHeader (const science_packet*, FILE*, long); 
  system_code ScienceRemapStare (const science_packet*, int, long&, FILE*, int, int);
  system_code ScienceGetTime (const PGSt_IO_L0_Packet*, const ncar_time*, double*);

#endif
