/********* MessageStareToByte.C ***************************************************************************************\

 !C

 $Header$

 PURPOSE
   Converts a stare number to a byte offset.

 INPUT ARGUMENTS
   long starenumber   A stare number to be converted into a byte offset.

 INPUT/OUTPUT ARGUMENTS
   None.

 OUTPUT ARGUMENTS
   None.

 RETURNS
   Byte offset of beginning of stare.
 
 ASSUMPTIONS ON ENTRY
   None.

 ASSUMPTIONS ON EXIT
   Starenumber was converted. 

 ORIGINAL VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/
#include "Message.h"
#include "Science.h"

// Coverts a stare number to a byte offset.
long MessageStareToByte (long starenumber)
{
  return (long)(CCSDS_HEADER_SIZE + ((starenumber - 1)/STARES_PER_PACKET) * SCI_PACKET_SIZE + 
		((starenumber - 1) % STARES_PER_PACKET) * STARE_SIZE); 
}

