/********* MessageOut.C ***************************************************************************************\

 !C

 $Header$

 PURPOSE
   Prints a message string to the desired output stream(s).

 INPUT ARGUMENTS
   None.

 INPUT/OUTPUT ARGUMENTS
   char* str    A string to be outputted.

 OUTPUT ARGUMENTS
   None.

 RETURNS
   Nothing.
 
 ASSUMPTIONS ON ENTRY
   String is a null terminated c-style character array.

 ASSUMPTIONS ON EXIT
   String was outputted. 

 ORIGINAL VERSION
   5/99  Tom Lauren

 REVISION HISTORY
   $Log$

 !END
\**********************************************************************************************************************/
#include <stdio.h>
#include "Message.h"
#include "PGS_SMF.h"

// Takes care of outputting warning/error messages.
void MessageOut (char* str)
{
  // Print message to screen.
  printf("%s\n", str);
  // Print message to LogReport.
  PGS_SMF_GenerateStatusReport (str);
}

