pro starecorrection, lofile, outfile

 forward_function GetNextPacket, ExtractPMC, GetMirror, $
	BadFirstCal, BadLastCal, RepackPMC, FindPeak, PeakDetect, $
	CalCorrect

  ; set the CCSDS header size
  headersize = 16  ; 15 CCSDS bytes + 1 extra MOPITT byte for word-aligning

  ; set the apid constants
  scienceapid     = 192

  ; set the packet stare size, stare byte size and the packet byte size
  packetstares = 5
  staresize = 1320
  nchannels = 2	
  packetsize = long (staresize * packetstares) + headersize
  staredata = bytarr(staresize)	
  choffset = lonarr(nchannels)
  choffset(0) = 420L  ; channel 3
  choffset(1) = 1068L ; channel 7
	minpacketsize = 6000L 

 ; open the file selected by the user
 openr, infileid, lofile, error = inerr, /get_lun

 if (inerr ne 0) then begin
	print, "Error opening ",lofile
     	exit
 endif 


;;;;;;;;;;;;;;;;;;;;;;;; LOG FILE ;;;;;;;;;;;;;;;;;;;;


logfile = outfile + '.log'
openw,logfileid,logfile, error=outerr,/get_lun
 if (outerr ne 0) then begin
	print, "Error opening ",logfile
     	exit
 endif 
printf,logfileid,'+++++++++++++ ',outfile,' ++++++++++++++'


; read in the first two bytes (to look at the APID)
  firstword = bytarr (2)
  readu, infileid, firstword

if firstword[1] ne scienceapid then begin
	print, "Unknown File Type APID = ",firstword[1]
	exit;
endif


; Reset the file
	point_lun,infileid,0L


  ; get the approximate number of stares in the file (err on the high side)
  fileinfo = fstat (infileid)
  npackets = (1L + (fileinfo.size / packetsize))
  stares = long (packetstares * (1L + (fileinfo.size / packetsize)))

  headers = bytarr(npackets,headersize)
  chcounts = lonarr(nchannels,npackets,packetstares,4,2,2)
  storestare = bytarr(npackets,packetstares,staresize)
  mirror = intarr(npackets,packetstares,4)

	jpacket = 0
	jstare = 0 

	keepreading = 1 ; TRUE

; while more data to be read
while (keepreading) do begin

  ; read in the next packet
  packetinfo = GetNextPacket (infileid, apid, headersize)

  if (EOF (infileid)) then begin
    keepreading = 0
    printf,logfileid,'NORMAL file ', jpacket
  endif	

  ;  if packetinfo.length gt 0 then begin
  if packetinfo.length ge minpacketsize then begin

    headers(jpacket,*) = packetinfo.header


    for istare = 0,packetstares-1 do begin
      starestart = istare * staresize
      stareend = starestart + staresize - 1

      storestare(jpacket,istare,*) = packetinfo.data(starestart:stareend)

      ; Get the packet position - Extract the PMC counts
      ; (channel x stare x pixels x stroke states x open/closed
      for ichan = 0,1 do begin
         chcounts(ichan,jpacket,istare,*,*,*) = ExtractPMC(choffset(ichan),storestare(jpacket,istare,*))
      endfor

	mirror(jpacket,istare,*) = GetMirror(storestare(jpacket,istare,*))

;		print,string(staredata(0)),' CH3 P1 Ho Hc Lo Lc', $
;			ch3counts(0,0,0),ch3counts(0,0,1),ch3counts(0,1,0), $
;			ch3counts(0,1,1)

    endfor

    jpacket = jpacket + 1

  endif else begin
    printf,logfileid,'not a NORMAL packet ', jpacket, packetinfo.length
    keepreading = 0
  endelse

endwhile ; done reading the file

free_lun,infileid


peakdip = intarr(2,2)
peakfind = intarr(2)
peakdip(*,*) = 0
peakfind(*) = 0
nopeak = 0


for ichan = 0,1 do begin

  itrain = ichan * 2 + 1

; check to make sure the number of cal events are correct
; Somehow we must prevent granules that begin or end during a cal event
; from messing everything up.

  calcorrect,mirror,itrain,chcounts(ichan)

  cc = where (mirror(*,*,itrain) eq -50 )
  nocal = 0

  if cc(0) eq -1 then begin
	printf,logfileid, 'NO COLD CALS IN GRANULE ',ichan 
	goto, NOPEAKFOUND
  endif

  ncc = n_elements(cc)/5

  ccal = lonarr(ncc,5,4,2,2)

  ic = 0
  fc = 0

; Somehow we must prevent granules that begin or end during a cal event
; from messing everything up.

  pos = lonarr(ncc,5,2)

  for ipack = 0,jpacket - 1 do begin

    for istare = 0,4 do begin

; if it is a coldcal put it in ccal
      if mirror(ipack,istare,itrain) eq -50 and ic lt ncc then begin
        ccal(ic,istare,*,*,*) = chcounts(ichan,ipack,istare,*,*,*)
	pos(ic,istare) = ipack
        fc = fc + 1
        if fc eq 5 then begin
          ic = ic + 1
          fc = 0
	endif
      endif


    endfor ; stares in packet
  endfor   ; next packet

  ccal_a = ccal

  av = lonarr(ncc,4,2,2)

; Remove the mean from each cal event
  for ipix = 0,3 do begin
    for istate = 0,1 do begin
      for ichop = 0,1 do begin

        for ic = 0, ncc - 1 do begin
          av(ic,ipix,istate,ichop) =  mean(ccal(ic,3:4,ipix,istate,ichop))
          ccal_a(ic,*,ipix,istate,ichop) = $
          ccal_a(ic,*,ipix,istate,ichop) - av(ic,ipix,istate,ichop)
        endfor

      endfor
    endfor
  endfor

; remove the peaks

  ccal_ap = ccal_a

  peakdip(ichan,*) = FindPeak(ccal_a(*,0,0,0,1))

  if (peakdip(ichan,0) lt 0 ) then begin
    printf,logfileid,'NO PEAK FOUND', ichan
    nopeak = nopeak + 1
    goto, NOPEAKFOUND
  endif

  peakremoval,ccal_a,ccal_ap, ncc, peakdip(ichan,0),2,0

; Search for peaks in positions 4 or 5
  for ipos = 3,4 do begin
    peakfound = peakdetect(ccal_ap,ncc,peakdip(ichan,0),ipos)
    if peakfound ne 0 then begin
      t_ccal = ccal_ap
      peakremoval,ccal_ap,t_ccal, ncc, peakdip(ichan,0),ipos,1
      ccal_ap = t_ccal 
      peakfind(ichan) = peakfind(ichan) + (ipos + 1) * peakfound
    endif
  endfor

; A good place to stop ^
;stop

; Restore the average

ccal_p = ccal_ap

  for ipix = 0,3 do begin
    for istate = 0,1 do begin
      for ichop = 0,1 do begin
        for ic = 0, ncc - 1 do begin

; checking the first position only 
          if ccal_ap(ic,0,ipix,istate,ichop) ne -9999  then $
				ccal_p(ic,*,ipix,istate,ichop) = $
				ccal_ap(ic,*,ipix,istate,ichop) + $
				av(ic,ipix,istate,ichop) $
				else 	ccal_p(ic,*,ipix,istate,ichop) = 0
	endfor
      endfor		
    endfor
  endfor

  for istare = 0,4 do begin

    for ipack = 0,ncc - 1 do begin
      chcounts(ichan,pos(ipack,istare),istare,*,*,*) = $
	ccal_p(ipack,istare,*,*,*)

      staredata = RepackPMC(choffset(ichan), $
      	chcounts(ichan,pos(ipack,istare),istare,*,*,*), $
	storestare(pos(ipack,istare),istare,*))

      storestare(pos(ipack,istare),istare,*) = staredata

    endfor

  endfor

NOPEAKFOUND: if nopeak eq 2 then begin

	command = 'cp ' + lofile + ' ' + outfile
	spawn,command
	goto, ALLDONE

endif



endfor  ; Channel Loop

openw, outfileid,outfile, error = outerr, /get_lun	

 if (outerr ne 0) then begin
	print, "Error opening ",outfile
     	exit
 endif 

for ipack = 0,jpacket - 1 do begin

	writeu, outfileid, headers(ipack,*)
	for istare = 0,4 do writeu, outfileid, storestare(ipack,istare,*)

endfor

free_lun,outfileid

for ichan = 0, 1 do begin
  ichannel = 4 * ichan + 3
  itrain = 2 * ichan + 1
  makelog,chcounts(ichan,*,*,*,*,*),mirror(*,*,itrain),ichannel,logfileid, $
	peakdip(ichan,1), peakfind(ichan)
endfor

ALLDONE: free_lun,logfileid



return
end


pro remove_anom,count, count_a,ncount

m = 1L

for ipkt = 0,ncount-1 do begin
	for ipos = 0,4 do begin
		for ipix = 0,3 do begin
			for istate = 0,1 do begin
				for ichop = 0,1 do begin
				m = mean(count(ipkt,3:4,ipix,istate,ichop))
          			count_a(ipkt,ipos,ipix,istate,ichop) = $
          			count(ipkt,ipos,ipix,istate,ichop) - m

				endfor
			endfor
		endfor
	endfor
endfor



return
end


pro peakremoval, ccal_a, ccal_ap, nc ,pp,npos,killflag


killed = -9999

for ipix = 0,3 do begin
	for ip = pp,nc - 1, 5 do begin
		for istate = 0,1 do begin
			for ichop = 0,1 do begin
				for ipos = 0,npos do begin
					if killflag eq 1 then begin
						ccal_ap(ip,ipos,ipix,istate,ichop) = killed 
					endif else begin
				if ip eq 0 then begin
					ccal_ap(0,ipos,ipix,istate,ichop) = $
					ccal_a(1,ipos,ipix,istate,ichop) 
				endif else begin
				if ip eq nc - 1 then begin
					ccal_ap(ip,ipos,ipix,istate,ichop) = $
					ccal_a(ip - 1,ipos,ipix,istate,ichop) 
				endif else begin
					ccal_ap(ip,ipos,ipix,istate,ichop) = $
					(ccal_a(ip - 1,ipos,ipix,istate,ichop) + $
					ccal_a(ip + 1,ipos,ipix,istate,ichop))/2
				endelse
				endelse
				endelse
				endfor
			endfor
		endfor		
	endfor
endfor


return
end


