#!/usr/local/bin/perl

# This program gets all the L0 files out of the PCF after the
# mirror position has been corrected and then calls the IDL
# program that removes the periodic peak.
#
#  Assumption: There is a PCF file that lists all the L0 files

$sips_path = $ENV{'SIPS_PATH'};
$stacor = "/usr/local/bin/idl $sips_path/L1/postpre-2.2/starecorrection.startup";

$pcf = $ENV{'PGS_PC_INFO_FILE'};

die "You must specify a valid PCF with the ENV variable PGS_PC_INFO_FILE\n" 
    unless (-s $pcf);

open(PCF, "<$pcf") || die "Cannot open $pcf\n";

@pcf = <PCF>;

close(PCF);

@L0filelines = ();

foreach $z (@pcf) {
    push(@L0filelines,$z) if $z =~ /^\d+\|MOPSCI-.+\|1$/;
}

die "No L0 files found within $pcf\n" unless (@L0filelines);

foreach $line (@L0filelines) {
    @parts = split(/\|/,$line);

    open(STACOR,"|$stacor") || die "Could not open $stacor\n";

    $file = $parts[2].'/'.$parts[1];
    
    print STACOR $file;

    close(STACOR);

    $fileout = $file.'.out';

    die "Peak removal failed $file\n" unless (-s $fileout);

    rename($fileout,$file);
}




