function BadFirstCal, mirror,train

; Is the first cal event bad?
; 0 is false
; >1 is true
status = 0


; Maybe the first position has the cal event - look in second position
; because of mirror position shift

if mirror(0,0,train) eq -50 and mirror(0,1,train) ne -50 then begin
	mirror(0,0,train) = -51
	return,1
endif

; The first packet doesnt have the cal event - look in second position
; because of mirror position shift
if mirror(0,1,train) ne -50 then return,status

for im = 1,4 do if mirror(0,im,train) eq -50 then status = status + 1

; set the first position to -50 if the next four (and not the next five)
; are cal events

if status eq 4 then begin
	if mirror(1,0,train) ne -50 then mirror(0,0,train) = -50 else mirror(0,0,train) = -51
	status = 0
endif else for im = 0,4 do if mirror(0,im,train) eq -50 then mirror(0,im,train) = -51
; in this else statement we set the position to -51 because it is an
; incomplete cal event.

cc = where (mirror(*,*,train) eq -50 )

nc = n_elements(cc)/5


return, status
end

function BadlastCal, mirror,train

; Is the last cal event bad?
; 0 is false
; >1 is true
status = 0

npac=n_elements(mirror(*,0,train))

; trim off packets that were not loaded
while ( mirror(npac-1,4,train) eq 0) do npac = npac - 1

for im = 0,4 do if mirror(npac-1,im,train) eq -50 then status = status + 1

if status eq 5 then return,0 else for im = 0,4 do $
	if mirror(npac-1,im,train) eq -50 then mirror(npac-1,im,train) = -51

cc = where (mirror(*,*,train) eq -50 )

ncc = n_elements(cc)
nc = ncc/5

; check again and exit if there's a problem.


ipos = 4
ipak = npac-1

while( nc * 5 ne ncc and cc(0) -1) do begin
	if (mirror(ipak,ipos,train) eq -50) then mirror(ipak,ipos,train) = -51

	ipos = ipos - 1
	if (ipos eq -1) then begin
		ipos = 4
		ipak = ipak - 1
	endif

	cc = where (mirror(*,*,train) eq -50 )
	ncc = n_elements(cc)
	nc = ncc/5

	

endwhile


return, status
end


pro calcorrect,mirror,train, counts

npac=n_elements(mirror(*,4,train))

incal = 0
rset = intarr(2)
rset(*) = -1
lookahead = intarr(5)

for ipac = 0,npac - 1 do begin
	for im = 0,4 do begin
		if mirror(ipac,im,train) eq -50 and incal eq 0 then begin
			incal = 1
			rset(0) = ipac + 1
			rset(1) = im
			lookahead(0) = -50
			jpac = ipac
			for ila = 1,4 do begin
				jm = im + ila
				if jm gt 4 then begin
					if jm eq 5 then jpac = jpac + 1
					jm = jm - 5
				endif

				lookahead(ila) = mirror(jpac,jm,train)
			endfor
			
			nocal = where(lookahead ne -50)
			if (nocal(0) ne -1) then begin
				mirror(ipac,im,train) = -52
				jpac = ipac
				for ila = 1,4 do begin
					jm = im + ila
					if jm gt 4 then begin
						if jm eq 5 then jpac = jpac + 1
						jm = jm - 5
					endif
					if mirror(jpac,jm,train) eq -50 or $
					 mirror(jpac,jm,train) lt -101  then $
						mirror(jpac,jm,train) = -52
				endfor
			endif					
			
		endif
		
		if ipac eq rset(0) and im eq rset(1) then incal = 0
	

	endfor
endfor

	mm = where(mirror(*,*,train) eq -52)
	if (n_elements(mm) eq 5) then begin

		z = fltarr(2,2)
		for istate = 0,1 do begin
			for iichop = 0,1 do begin
                           print, iichop
                           z(istate,iichop) = mean(counts(*,*,*,istate,iichop))	
			endfor
		endfor

		for ipac = 0,npac-1 do begin
			for ipos = 0,4 do begin
				if mirror(ipac,ipos,train) eq -52 then begin
					for ipix = 0,3 do counts(ipac,ipos,ipix,*,*) = z
					mirror(ipac,ipos,train) = -50

				endif
		
			endfor
		endfor


	endif



end

















