pro makelog,counts,mirror,chan,logfileid,pdip,pfind

npkt = n_elements(counts(0,*,0,0,0,0))

nc = n_elements(where(mirror eq -50))/5 
nw = n_elements(where(mirror eq -100))/5
ne1 = n_elements(where(mirror gt -40))/5

cc = lonarr(nc,5,4,2,2)
ww = lonarr(nw,5,4,2,2)
ee = lonarr(npkt,5,4,2,2)
ee_c = lonarr(npkt,5,4,2,2)

ee(*,*,*,*,*) = -99

nnc = 0

nada = 0

ic = 0
iw = 0
ie = 0

jc = 0
jw = 0
je = 0

for ipkt = 0,npkt-1 do begin
	for ipos = 0,4 do begin
		if mirror(ipkt,ipos) eq -50 and ic lt nc then begin
			if (counts(0,ipkt,ipos,0,0,0) gt 0) then begin
				cc(ic,ipos,*,*,*) = counts(0,ipkt,ipos,*,*,*)
				jc = jc + 1
				if (jc eq 5) then  begin
					jc = 0
					ic = ic + 1
				endif
			endif else nnc = nnc + 1
		endif

		if mirror(ipkt,ipos) eq -100 and iw lt nw then begin
			ww(iw,ipos,*,*,*) = counts(0,ipkt,ipos,*,*,*)
			jw = jw + 1
			if (jw eq 5) then  begin
				jw = 0
				iw = iw + 1
			endif
		endif


; toss out spikes - cutoff is set arbitrarily
		if mirror(ipkt,ipos) gt -40 and ie lt ne1 and counts(0,ipkt,ipos,0,0,1) lt 8e6 $
		then ee(ipkt,ipos,*,*,*) = counts(0,ipkt,ipos,*,*,*)
	
	endfor
endfor


fullpkt = 0
for ipkt = 0,npkt-1 do begin

	z = where(ee(ipkt,*,0,0,0) le 0 )
	if (z(0) eq -1) then begin
		ee_c(fullpkt,*,*,*,*) = ee(ipkt,*,*,*,*)
		fullpkt = fullpkt + 1
	endif
endfor

if ( fullpkt lt 1 ) then begin
	nada = 1
	goto, DONELOG
endif
ee_a = lonarr(fullpkt,5,4,2,2)

ww_a = ww

nnnc = nc - nnc/5 -1 
cc_a = cc(0:nnnc,*,*,*,*)

remove_anom,ee_c,ee_a,fullpkt
remove_anom,cc,cc_a,nnnc + 1
remove_anom,ww,ww_a,nw


allstrmean = fltarr(2,2)
strmean = fltarr(5,2,2)
strmean_a = fltarr(5,2,2)
strstddev = fltarr(5,2,2)

viewtype = strarr(3)
viewtype(0) = 'COLD'
viewtype(1) = 'WARM'
viewtype(2) = 'EARTH'

norm_factors=dblarr(8,2)

norm_factors(3,0) =0.01980198	
norm_factors(3,1) =0.029850746
norm_factors(7,0) =0.017094017
norm_factors(7,1) =0.024691358

c_avdi = fltarr(5,2)
e_avdi = fltarr(5,2)

printf,logfileid,'*** CHANNEL ' + strtrim(string(chan),2) + ' ***'
if pdip gt 0 then printf,logfileid,'Low Closed pos 1: + PEAK' else $
	printf,logfileid,'Low Closed pos 1: - PEAK'

case pfind of 
	0 : printf,logfileid,'Nothing found in pos 4 or 5'
	1: printf,logfileid,'- PEAK in pos 4 + PEAK in pos 5'
	4 : printf,logfileid,'+ PEAK found in pos 4'
	5 : printf,logfileid,'+ PEAK found in pos 4'
	9 : printf,logfileid,'+ PEAK found in pos 4 & 5'
	-1: printf,logfileid,'+ PEAK in pos 4 - PEAK in pos 5'
	-4 : printf,logfileid,'- PEAK found in pos 4'
	-5 : printf,logfileid,'- PEAK found in pos 4'
	-9 : printf,logfileid,'- PEAK found in pos 4 & 5'
	else : printf,logfileid,'Strange Situation'
endcase


for ipix = 0,3 do begin
	printf,logfileid,'********** PIXEL ********* ',ipix
	for vt = 0,2 do begin
		printf,logfileid,'********** VIEWTYPE ********* ',viewtype(vt)

		for istate = 0,1 do begin
			for ichop = 0,1 do begin
				if vt eq 0 then allstrmean(istate,ichop) = mean(cc_a(*,3:4,ipix,istate,ichop))			
				if vt eq 1 then allstrmean(istate,ichop) = mean(ww_a(*,3:4,ipix,istate,ichop))			
				if vt eq 2 then allstrmean(istate,ichop) = mean(ee_a(*,3:4,ipix,istate,ichop))			


				for istr = 0 , 4 do begin
	
	if vt eq 0 then begin
 		if (n_elements(cc(0:nnnc,istr,ipix,istate,ichop))) ge 2 then begin
			strmean(istr,istate,ichop) = $
			mean(cc(0:nnnc,istr,ipix,istate,ichop)) 
			strmean_a(istr,istate,ichop) = $
			mean(cc_a(*,istr,ipix,istate,ichop)) 
			strstddev(istr,istate,ichop) = $
			stddev(cc_a(*,istr,ipix,istate,ichop)) 
		endif else begin
; hot cal - no data
			strmean(istr,istate,ichop) = 0.
			strmean_a(istr,istate,ichop) = 0.
			strstddev(istr,istate,ichop) = 0.
		endelse
		
	endif
	

	if vt eq 1 then begin
 		if (n_elements(ww(*,istr,ipix,istate,ichop))) ge 2 then begin
			strmean(istr,istate,ichop) = $
			mean(ww(*,istr,ipix,istate,ichop)) 
			strmean_a(istr,istate,ichop) = $
			mean(ww_a(*,istr,ipix,istate,ichop)) 
			strstddev(istr,istate,ichop) = $
			stddev(ww_a(*,istr,ipix,istate,ichop)) 
		endif else begin
; hot cal - no data
			strmean(istr,istate,ichop) = 0.
			strmean_a(istr,istate,ichop) = 0.
			strstddev(istr,istate,ichop) = 0.
		endelse
	endif

	if vt eq 2 then begin
		if (n_elements(ee(*,istr,ipix,istate,ichop))) ge 2 then begin
			strmean(istr,istate,ichop) = $
			mean(ee_c(0:fullpkt-1,istr,ipix,istate,ichop)) 
			strmean_a(istr,istate,ichop) = $
			mean(ee_a(*,istr,ipix,istate,ichop)) 
			strstddev(istr,istate,ichop) = $
			stddev(ee_a(*,istr,ipix,istate,ichop)) 
		endif else begin
; hot cal - no data
			strmean(istr,istate,ichop) = 0.
			strmean_a(istr,istate,ichop) = 0.
			strstddev(istr,istate,ichop) = 0.
		endelse
	endif


				endfor
			endfor
		endfor

		strmean(*,*,0) = strmean(*,*,0) * norm_factors(chan,0) 
		strstddev(*,*,0) = strstddev(*,*,0) * norm_factors(chan,0) 
		strmean_a(*,*,0) = strmean_a(*,*,0) * norm_factors(chan,0) 
		strmean(*,*,1) = strmean(*,*,1) * norm_factors(chan,1) 
		strstddev(*,*,1) = strstddev(*,*,1) * norm_factors(chan,1) 
		strmean_a(*,*,1) = strmean_a(*,*,1) * norm_factors(chan,1) 


		if vt eq 0 then begin
			for istr =0,4 do begin
			lo = strmean(istr,0,0) - strmean(istr,0,1)
			hi = strmean(istr,1,0)  - strmean(istr,1,1) 

			c_avdi(istr,0) = (lo + hi)/2.

			c_avdi(istr,1) = (lo - hi)

			endfor

		endif


		if vt eq 2 then begin
			for istr =0,4 do begin
			lo = strmean(istr,0,0) - strmean(istr,0,1)
			hi = strmean(istr,1,0) - strmean(istr,1,1)

			e_avdi(istr,0) = (lo + hi)/2.

			e_avdi(istr,1) = (lo - hi)

			endfor

		endif

		printf,logfileid,'stare 1    2    3    4    5'
		printf,logfileid,'     m,s  m,s  m,s  m,s  m,s'

		strstart = strarr(2,2)
		strstart(0,0) = 'LO '
		strstart(0,1) = 'LC '
		strstart(1,0) = 'HO '
		strstart(1,1) = 'HC '

		for istate = 0,1 do begin
			for ichop = 0,1 do begin
				str = strstart(istate,ichop) 
				for istr =0,4 do begin
					z = strmean_a(istr,istate,ichop) $
						-allstrmean(istate,ichop)
					zs = strtrim(string(z),2)
					xs = strtrim(string(strstddev(istr,istate,ichop)),2) 
					str = str + zs + ' ' + xs + ' '
				endfor
	
				printf,logfileid,str
			endfor
		endfor
	
	endfor


	ezdifmean = mean(e_avdi(3:4,1) - c_avdi(3:4,1))	
	q = fltarr(5)
	if (ezdifmean ne 0.) then $
			for istr =0,4 do q(istr) =  $
	100. * ((e_avdi(istr,1) - c_avdi(istr,1)) - ezdifmean)/ezdifmean $
			else for istr =0,4 do q(istr) = -1.

	printf,logfileid, '****** EARTH  AV  DI ********'
	for istr =0,4 do printf,logfileid,'str ',strtrim(string(istr+1),2),$
		e_avdi(istr,0) ,e_avdi(istr,1)
	printf,logfileid, '****** COLD  AV  DI ********'
	for istr =0,4 do printf,logfileid,'str ',strtrim(string(istr+1),2),$
		c_avdi(istr,0) ,c_avdi(istr,1)
	printf,logfileid, '****** EARTH-COLD  AV  DI  %-DI-bias ********'
	for istr =0,4 do printf,logfileid,'str ',strtrim(string(istr+1),2),$
		e_avdi(istr,0) - c_avdi(istr,0), $
		e_avdi(istr,1) - c_avdi(istr,1), q(istr)



endfor

DONELOG : if nada eq 1 then printf,logfileid,'NOTHING TO LOOK AT'

return
end















