function FindPeak,array

  vals = lonarr(5)
  npts = n_elements(array)

  peakpos = intarr(2)

  ival = 0
  cnt = intarr(5)

  for ipts = 0, npts -1 do begin
      vals(ival) = vals(ival) + array(ipts)
      cnt(ival) = cnt(ival) + 1
      ival = ival + 1
      if (ival eq 5) then ival = 0
  endfor

  for ic = 0,4 do begin
      if (cnt(ic) gt 0) then vals(ic) = vals(ic)/cnt(ic) else goto, NOPEAK
  endfor

  vm = mean(vals)
  vsd = stddev (vals)

  peakpos(0) = -1
  peakpos(1) = 0


  for i = 0,4 do begin
      if vals(i) gt vm + vsd then begin
          peakpos(0) = i
          peakpos(1) = 1
      endif

      if vals(i) lt vm - vsd then begin
          peakpos(0) = i
          peakpos(1) = -1
      endif
  endfor
  print, "peakpos(0)=", peakpos(0)

  NOPEAK: if peakpos(0) lt 0 then begin
      print, 'NO PEAK DETECTED'
      peakpos(0) = -99
      peakpos(1) = -99
  endif

  return, peakpos
end



function peakdetect,ccal,npts,pp,ipos

; ccal (calevent,pakpos,pixel,state,chopper) 

vals = lonarr(5)
cnt = intarr(5)

peakfound = 0
vals(*) = 0
cnt(*) = 0
ival = 0


for ipts = 0, npts -1 do begin
	vals(ival) = vals(ival) + ccal(ipts,ipos,0,0,0)
	cnt(ival) = cnt(ival) + 1
	ival = ival + 1
	if (ival eq 5) then ival = 0
endfor

vals = vals/cnt
vm = mean(vals)
vsd = stddev (vals)

if (pp eq 0) then begin
	vmmp = mean(vals(1:*))
	vsdmp = stdev(vals(1:*))
endif else begin
	if (pp eq 4) then begin
		vmmp = mean(vals(0:3))
		vsdmp = stdev(vals(0:3))
	endif else begin
		array = intarr(4)
		array(0:pp-1) = vals(0:pp-1)
		array(pp:*) = vals(pp+1:*)
		vmmp = mean(array)
		vsdmp = stdev(array)
	endelse
endelse

	
for i = 0,4 do begin
	if vals(pp) gt vmmp + vsdmp then peakfound = 1
	if vals(pp) lt vmmp - vsdmp then peakfound = -1
endfor

return, peakfound
end



