function ExtractPMC, chanoffset, staredata

; set the number of channel header bytes
  headerbytes = 6

; foldover value
  fo = 392954

; make room for the counts (pixels x stroke states x open/closed
  counts = lonarr (4, 2, 2)

  ; make room for the data (tempbytes is temporary storage)
  pmcdatasize = 54
  tempbytes = bytarr (pmcdatasize - headerbytes)
  countbytes = bytarr (pmcdatasize - headerbytes)

  pmcstart = chanoffset + headerbytes
  pmcstop = pmcstart + pmcdatasize - 1
  tempbytes = staredata(pmcstart:pmcstop)

    for pixel = 0, 3 do begin
      pos = pixel * 12
      counts[pixel,0,0] = (tempbytes[pos+1] * 65536L) + (tempbytes[pos+ 0] * 256L) + tempbytes[pos+ 3]
      counts[pixel,1,0] = (tempbytes[pos+2] * 65536L) + (tempbytes[pos+ 5] * 256L) + tempbytes[pos+ 4]
      counts[pixel,0,1] = (tempbytes[pos+7] * 65536L) + (tempbytes[pos+ 6] * 256L) + tempbytes[pos+ 9]
      counts[pixel,1,1] = (tempbytes[pos+8] * 65536L) + (tempbytes[pos+11] * 256L) + tempbytes[pos+10]
    endfor

return,counts
end

function GetMirror, staredata

; make the mirror offset
mirroroffset =  12

  ; make room for the return values
  mirrorinfo = intarr (4)

  ; get the mirror info
  mirrorinfo[0] = (staredata[mirroroffset + 0] * 256) + staredata[mirroroffset + 1]
  mirrorinfo[1] = (staredata[mirroroffset + 2] * 256) + staredata[mirroroffset + 3]
  mirrorinfo[2] = (staredata[mirroroffset + 4] * 256) + staredata[mirroroffset + 5]
  mirrorinfo[3] = (staredata[mirroroffset + 6] * 256) + staredata[mirroroffset + 7]

  ; return the mirror info
  return, mirrorinfo
end


function RepackPMC, chanoffset, incounts, staredata

; set the number of channel header bytes
  headerbytes = 6
stnuoc = intarr(12)

counts = lonarr(4,2,2)
counts(*,*,*) = incounts(0,0,0,*,*,*)
newstare = staredata

    for pixel = 0, 3 do begin
	stnuoc(1) = byte(counts(pixel,0,0)/65536L)
	stnuoc(0) = byte((counts(pixel,0,0) - (65536L * stnuoc(1)))/256L )
	stnuoc(3) = byte (counts(pixel,0,0) - (65536L * stnuoc(0)) $
		- (stnuoc(1) * 256L))

	stnuoc(2) = byte(counts(pixel,1,0)/65536L)
	stnuoc(5) = byte((counts(pixel,1,0) - (65536L * stnuoc(2)))/256L )
	stnuoc(4) = byte (counts(pixel,1,0) - (65536L * stnuoc(2)) $
		- (stnuoc(5) * 256L))


	stnuoc(7) = byte(counts(pixel,0,1)/65536L)
	stnuoc(6) = byte((counts(pixel,0,1) - (65536L * stnuoc(7)))/256L )
	stnuoc(9) = byte (counts(pixel,0,1) - (65536L * stnuoc(7)) $
		- (stnuoc(6) * 256L))


	stnuoc(8) = byte(counts(pixel,1,1)/65536L)
	stnuoc(11) = byte((counts(pixel,1,1) - (65536L * stnuoc(8)))/256L )
	stnuoc(10) = byte (counts(pixel,1,1) - (65536L * stnuoc(8)) $
		- (stnuoc(11) * 256L))

	pos = pixel * 12 + chanoffset + headerbytes

;r1 = stnuoc
;r2 = staredata(0,0,pos:pos+11)

   	newstare(0,0,pos:pos+11) = stnuoc

    endfor
  


return, newstare
end

