   pro rdshepherdwood,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rndat,ridat,rnerr,rierr

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file is filnm

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlines=ncdf_varid(nc_id,'nlines')
  idnwave=ncdf_varid(nc_id,'nwave')

; idnweights=ncdf_varid(nc_id,'nweights')
; idwhno3=ncdf_varid(nc_id,'whno3')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

  idtext=ncdf_varid(nc_id,'text')
  idshepherdstrs=ncdf_varid(nc_id,'shepherdstrs')

  idn70=ncdf_varid(nc_id,'n70')
  idn10=ncdf_varid(nc_id,'n10')
  idn2=ncdf_varid(nc_id,'n2')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn10,n10
  ncdf_varget,nc_id,idn2,n2
  ncdf_varget,nc_id,idnlines,nlines
  ncdf_varget,nc_id,idnwave,nwave

  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

  text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

  shepherdstrs=strarr(n10,n2)
  ncdf_varget,nc_id,idshepherdstrs,shepherdstrs
  shepherdstrs=string(shepherdstrs)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
   ihelp=0
  if (ihelp eq 1) then begin
   help,rn
   help,ri
   help,wcm
   help,wavelength
   help,nwave
   help,ntext
   help,text
   help,shepherdstrs
; RN              FLOAT     = Array[12, 2]
; RI              FLOAT     = Array[12, 2]
; WCM             FLOAT     = Array[12]
; WAVELENGTH      FLOAT     = Array[12]
; NWAVE           INT       =       12
; NTEXT           INT       =       14
; TEXT            STRING    = Array[14]
; SHEPHERDSTRS    STRING    = Array[2]
   stop
  endif

; *****
   shepherdstrs=strarr(nlines)
;                '1234567890','1234567890'
   shepherdstrs=['Wood smoke 0','Humic acid 1']

  print,'  '
  print,'  Shepherd ',shepherdstrs
  print,'  specify j (from 0 to 1)'
  read,j

  jval=j

; ***
   text2=string(shepherdstrs(j))
;  lset=strcompress(lstrn+text2)

; *****
; Output
   nlines=nwave

; Specify the indices
    rndat=fltarr(nwave)
    ridat=fltarr(nwave)
; have as zero
    rnerr=fltarr(nwave)
    rierr=fltarr(nwave)
   for i=0,nwave-1 do begin
    rndat(i)=rn(i,j)
    ridat(i)=ri(i,j)
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdshepherdwood: filnm ',filnm
    printf,iout,'  '
    printf,iout,'  rdshepherdwood: next ',ntext
    printf,iout,'  rdshepherdwood: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdshepherdwood: nlines ',nlines
   printf,iout,'  rdshepherdwood: shepherdstrs(j) ',shepherdstrs(j)
   printf,iout,'  rdshepherdwood: i,wcm,wavelength,rndat and ridat'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
