  pro grmultisets,noprg,iout,fileps,icase,$
  nwave,nfiles,wavecm,wavelength,rn,ri,$
  curvelabels,titlegr,fsaveset

; Graph the data

; The user may need to change the x and y values (0 to 1) on the page
; of the curve labels

; ****************
   set_plot, 'ps'
  device, /color, bits_per_pixel=8, file=fileps,$
   /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; specify the color palette
; see pg 16-10 of the user's guide
   icolor=1
  if (icolor eq 1) then begin
   loadct, 26
  endif
  if (icolor eq 0) then begin
   loadct, 0
  endif

; For bold type
  !P.font=0

; specify the character size for the labels
  csizet=1.5
  csizel=1.0

; have graphs plus the color bar
; [ignore,horizontal,vertical]
   nmult=1
  !P.MULTI=[0,1,nmult]

  xm=4

; ************
    ndat=nwave
    nlines=nfiles

    mpts=ndat
    ntot=nlines*mpts
    npts=ntot

   xvec=fltarr(ntot)
   yvec=fltarr(ntot)
   veccolor=fltarr(ntot)
   isymn=intarr(ntot)

   xvecn=fltarr(mpts,nlines)
   yvecn=fltarr(mpts,nlines)

   clrval=fltarr(nlines)

   if (nlines eq 2) then begin
    clrval=[30.0,250.0]
   endif
   if (nlines eq 3) then begin
    clrval=[30.0,70.0,250.0]
   endif
   if (nlines eq 4) then begin
    clrval=[30.0,70.0,100.0,250.0]
   endif
   if (nlines eq 5) then begin
    clrval=[30.0,70.0,100.0,150.0,250.0]
   endif
   if (nlines eq 6) then begin
    clrval=[30.0,40.0,70.0,100.0,150.0,250.0]
   endif
   if (nlines eq 7) then begin
    clrval=[5.0,30.0,40.0,70.0,100.0,150.0,250.0]
   endif

   if (nlines gt 7) then begin
    printf,iout,'  '
    printf,iout,'  grmultisets: user need to supply longer list of clrval values'  
    print,'  grmultisets: user need to supply longer list of clrval values, will stop'  
    stop
   endif

   igraphdat=0

; ***
   for i=0,mpts-1 do begin
   for j=0,nlines-1 do begin
    xvecn(i,j)=wavelength(i,0)
; Real indices
    if (icase eq 1) then begin
     yvecn(i,j)=rn(i,j)
    endif
; Imaginary indices
    if (icase eq 2) then begin
     yvecn(i,j)=ri(i,j)
    endif
   endfor
   endfor

; ***
    n=-1
   for j=0,nlines-1 do begin

   for i=0,mpts-1 do begin
     n=n+1
    xvec(n)=wavelength(i)
    yvec(n)=yvecn(i,j)
    veccolor(n)=clrval(j)
    isymn(n)=4
   endfor

   endfor

; **
   xmin=min(xvec)
   xmax=max(xvec)
   ymin=0.0
   ymax=max(yvec)

   xr1=min(xvec)
   xr2=max(xvec)
   yr1=0.0
   yr2=max(yvec)

   labelx='Wavelength (microns)'
   if (icase eq 1) then begin
    labely='Real Index'
   endif
   if (icase eq 2) then begin
    labely='Imaginary Index'
   endif
   title=strcompress(titlegr)

; **
    isetb=2
   if (isetb eq 1) then begin
    x1a=0.15
    x2a=0.85
    y1a=0.10
    y2a=0.80
   endif
   if (isetb eq 2) then begin
    x1a=0.20
    x2a=0.80
    y1a=0.20
    y2a=0.80
   endif

; **
   igrwords=1
    nlabels=nlines
   grwords=strarr(nlabels)
   xwords=fltarr(nlabels)
   ywords=fltarr(nlabels)
   wordc=fltarr(nlabels)

; Real indices
; The user may need to change the x and y values (0 to 1) on the page
; of the curve labels
   if (icase eq 1) then begin
     yval=0.55
     eps=0.05
    for i=0,nlines-1 do begin
     grwords(i)=curvelabels(i)
     xwords(i)=0.40
     yval=yval-eps
     ywords(i)=yval
     wordc(i)=clrval(i)
    endfor
   endif

; Imaginary indices
; The user may need to change the x and y values (0 to 1) on the page
; of the curve labels
   if (icase eq 2) then begin
     yval=0.80
     eps=0.05
    for i=0,nlines-1 do begin
     grwords(i)=curvelabels(i)
     xwords(i)=0.40
     yval=yval-eps
     ywords(i)=yval
     wordc(i)=clrval(i)
    endfor
   endif

; **
; Graph the multiple set of lines
    noprg=0
   graphmultisets,noprg,iout,$
   npts,xvec,yvec,veccolor,isymn,clrval,$
   nlines,xvecn,yvecn,igraphdat,mpts,$
   labelx,labely,title,$
   xmin,xmax,ymin,ymax,$
   x1a,y1a,x2a,y2a,$
   igrwords,grwords,xwords,ywords,wordc,$
   xr1,xr2,yr1,yr2

; **
; write out to the saveset
   save,npts,xvec,yvec,veccolor,isymn,clrval,$
   nlines,xvecn,yvecn,igraphdat,mpts,$
   labelx,labely,title,$
   xmin,xmax,ymin,ymax,$
   x1a,y1a,x2a,y2a,$
   igrwords,grwords,xwords,ywords,wordc,$
   xr1,xr2,yr1,yr2,$
   file=fsaveset

   printf,iout,'  '
   printf,iout,'  grmultisets: wrote to the saveset ',fsaveset
   print,'  wrote to the saveset ',fsaveset

; **************
  device,/close
  print,fileps

; ******************************
  return
  end
