  pro test2,nopr,$
  iout,indir,outdir,fout

; *****
; The output ps graphics file
  fileps=strcompress(outdir+'test2.ps')

  printf,iout,'  test1: ',fileps

; *****
; Open the output ps file
  set_plot, 'ps'
  device, /color, bits_per_pixel=8, file=fileps,$
   /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; *****
; Number of angles to specify for bhmie2.pro
   nang=20

; See Liou pg 138 for a graph of the values graphed here in this routine
; An Introduction to Atmospheric Radiation (1st edition)

; There ndist points in the spectrum
    ndist=100

; Liou's graph has ncases curves.
     ncases=4
    xs=fltarr(ndist,ncases)

; Q for extinction
    qexts=fltarr(ndist,ncases)
; Q for scattering
    qscas=fltarr(ndist,ncases)
; Q for absorption
    qabs=fltarr(ndist,ncases)
; Q for backscatering
    qbacks=fltarr(ndist,ncases)

    xvec=fltarr(ndist)
    yvec=fltarr(ndist)
    yvec2=fltarr(ndist)
    yvec3=fltarr(ndist)
    isym=intarr(ndist)

; Real and imaginary indices of refraction
; 1.33 is for water
    refreal=fltarr(ncases)
    refim=fltarr(ncases)
    refreal=[1.33,1.33,1.33,1.33]
    refim=[0.0,0.01,0.1,1.0]

; For the titles of the graphs
    titles=strarr(ncases)
    titles=['1.33r, 0i ','1.33r, 0.01i ','1.33r, 0.1i ','1.33r, 1i ']

; ****
; Loop over cases
   for j=0,ncases-1 do begin

; The complex index of refraction
    refrel=complex(refreal(j),refim(j))

    printf,iout,'  '
    printf,iout,'  test1: *****'
    printf,iout,'  test1: titles(j) ',titles(j)
    printf,iout,'  test1: j,refrel ',j,refrel
    printf,iout,'  test1: qext is the MIE Q efficiency factor for extinction'
    printf,iout,'  test1: i,x,qext,qabs,qsca,qsca,qback'

   for i=0,ndist-1 do begin

    x=1.00*(i+1)

; Call the BHMIE routine of Bohren and Huffman "Absorption and Scattering
; of Light by Small Particles"
    bhmie2,x,refrel,nang,s1,s2,qext,qsca,qback,gfac

    xs(i,j)=x
    qexts(i,j)=qext
    qscas(i,j)=qsca
     a1=qext-qsca
    if (a1 lt 0.0) then begin
     a1=0.0
    endif
    qabs(i,j)=a1
    qbacks(i,j)=qback

    printf,iout,'  ',i,x,qext,a1,qsca,qback

    xvec(i)=x
    yvec(i)=qsca
    yvec2(i)=qext
    yvec3(i)=a1
    isym(i)=4

   endfor

; **
; Graph the data
   xmin=min(xvec)
   xmax=max(xvec)
   ymin=min(yvec)
   ymax=max(yvec)

   labelx='2 pi rad / wavelength'
   labely='Q scattering '

   ixlog=1
   iylog=0

   title=titles(J)

   ioplot=1

   graphxy,iout,xvec,yvec,isym,ndist,labelx,labely,title,$
   xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

; **
; Graph the data
   xmin=min(xvec)
   xmax=max(xvec)
   ymin=min(yvec2)
   ymax=max(yvec2)

   labelx='2 pi rad / wavelength'
   labely='Q extinction '

   ixlog=1
   iylog=0

   title=titles(J)

   ioplot=1

   graphxy,iout,xvec,yvec2,isym,ndist,labelx,labely,title,$
   xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

; **
; Graph the data
   xmin=min(xvec)
   xmax=max(xvec)
   ymin=min(yvec3)
   ymax=max(yvec3)

   labelx='2 pi rad / wavelength'
   labely='Q absorption'

   ixlog=1
   iylog=0

   title=titles(J)

   ioplot=1

   graphxy,iout,xvec,yvec3,isym,ndist,labelx,labely,title,$
   xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps



   endfor
; Loop over cases

; **
; Close the ps device
   device,/close

   print,'  output ps file is located at ',fileps

; *****
  return
  end
