  pro test1,nopr,$
  iout,indir,outdir,fout

; *****
; The output ps graphics file
  fileps=strcompress(outdir+'test1.ps')

  printf,iout,'  test1: ',fileps

; Write out conversions from dV/dlnr to dN/dlnr parameters
  noprc=1

; *****
; Open the output ps file
  set_plot, 'ps'
  device, /color, bits_per_pixel=8, file=fileps,$
   /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

   icase1=0
   icase2=6
  for icase=icase1,icase2 do begin

; *****
; Examine a lognormal size distribution - before a volcanic eruption
; Deshler Wyoming measurements at 20 km (910501.UWY)
  if (icase eq 0) then begin

  lsetg='Stratospheric sulfate pre-Pinatubo'

; Specify the parameters of the log-normal size distribution, both modes

; The first mode (number/cm3, mean radii (microns), sigma width)  (den1,rad1,sig1)
  den1=7.48
  rad1=6.91e-2
  sig1=1.66

; The second mode (number/cm3, mean radii (microns), sigma width) (den2,rad2,sig2)
  den2=0.0
  rad2=0.0
  sig2=0.0

; Specify the radii range r1,r2 of the size distribution in microns
  r1=0.005
  r2=3.0

; Will use calcsized.pro to calculate the size distribution
  icalc=1

  endif

; *****
; Examine a lognormal size distribution - after a volcanic eruption
; Deshler Wyoming measurements at 19 km (911212.UWY)
  if (icase eq 1) then begin

  lsetg='Stratospheric sulfate post-Pinatubo'

  den1=16.4
  rad1=0.231
  sig1=1.49
  den2=1.60
  rad2=0.547
  sig2=1.25
  r1=0.005
  r2=3.0
  icalc=1

  endif

; *****
; Examine a water drop size distribution
  if (icase eq 2) then begin

; See Hess M, Koepke P, Shult I, Optical Properties of Aerosols and
; Clouds: The Software Package OPAC. Bull Am Met Soc 1998;79:831-844. 

  lsetg='Hess: Maritime Stratus '

  alpha=3.0
  gamma=1.30
  a=3.818e-3
  b=0.193
  reff=11.30
  den=80.0
  lrho=0.30
  r1=0.1
  r2=50.0

  gammasize,noprc,iout,lsetg,$
  alpha,gamma,a,b,reff,den,lrho,r1,r2,$
  ndist,radr,sized

  icalc=2

  endif

; *****
; Examine a Polar Stratospheric Cloud (PSC) size distribution
  if (icase eq 3) then begin

; See Deshler, T.  J Geophys Res., vol 105, pgs 3943-3953, feb 16, 2000,
; Determining the index of refraction of polar stratospheric
; clouds above Andoya (69øy combining size-resolved
; concentration and optical scattering measurements

  lsetg='Deshler: PSC Andoya 960123'

  den1=8.23
  rad1=0.28
  sig1=1.39
  den2=0.005
  rad2=1.68
  sig2=1.34
  r1=0.01
  r2=5.0
  icalc=1

  endif

; *****
; Examine a desert dust size distribution
  if (icase eq 4) then begin

  lsetg='Dubovik: Bahrain-Persian Gulf'

; dV/dlnr
; Bahrain-Persian Gulf
   tau1020=0.5
  cfine=0.02+(0.1*tau1020)
  ccoarse=-0.02+(0.1*tau1020)
  rfine=0.15
  rcoarse=2.54
  sigfine=0.42
  sigcoarse=0.61
  r1=0.01
  r2=20.0
  icalc=1

; Convert to log-normal parameters
   convertsizep,nopr,iout,lsetg,$
   cfine,rfine,sigfine,den1,rad1,sig1
   convertsizep,nopr,iout,lsetg,$
   ccoarse,rcoarse,sigcoarse,den2,rad2,sig2

  endif

; *****
; Examine a clean continental size distribution
  if (icase eq 5) then begin

  lsetg='Seinfeld-Pandis: Rural '

; See Seinfeld JH, Pandis SN. Atmospheric Chemistry and Physics. New York: John 
; Wiley and Sons; 1998.

  den1=6650.0
  rad1=0.015/2.0
  sig1=exp(0.225)

  den2=147.0
  rad2=0.054/2.0
  sig2=exp(0.557)

; Note that table 7.3 also had a third mode

  r1=0.005
  r2=3.0
  icalc=1

  endif

; *****
; Examine a poluted urban size distribution
  if (icase eq 6) then begin

  lsetg='Dubovik: Mexico City'

; dV/dlnr
   tau440=0.5
  cfine=0.12*tau440
  ccoarse=0.09*tau440
  rfine=0.12+(0.025*tau440)
  rcoarse=3.22+(0.71*tau440)
  sigfine=0.40
  sigcoarse=0.73
  r1=0.001
  r2=2.0
  icalc=1

; Convert to log-normal parameters
   convertsizep,noprc,iout,lsetg,$
   cfine,rfine,sigfine,den1,rad1,sig1
   convertsizep,noprc,iout,lsetg,$
   ccoarse,rcoarse,sigcoarse,den2,rad2,sig2

  endif

; *****
; Calculate the size distribution with ndist points

; Print flags
   noprsize=0
   iwrsize=0

; Specify igraphd. To graph the size distribution put igraphd=1 (0 don't graph)
   igraphd=0

  if (icalc eq 1) then begin
   calcsized,noprsize,iout,$
   r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   ndist,radr,sized,$
   outdir,igraphd,iwrsize,$
   lsetg
  endif

; *****
; Graph the data
      ngraphs=1
     titles=strarr(ngraphs)
     titles=['Size Distribution (number cm-3 per micron radii increment)']

     xvec=fltarr(ndist)
     yvec=fltarr(ndist)
     isym=intarr(ndist)

; Loop over the graphs
    for ii=0,ngraphs-1 do begin

      for i=0,ndist-1 do begin
       xvec(i)=radr(i)
       yvec(i)=sized(i)
       isym(i)=4
      endfor

; For log-normal size distributions
    if (icalc eq 1) then begin
     labelx='Radius (microns)'
     labely=titles(ii)
     title=lsetg
    endif

; For gamma size distribution
    if (icalc eq 2) then begin
     labelx='Radius (microns)'
     labely=titles(ii)
     title=lsetg
    endif

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    ixlog=1
    iylog=1
    ioplot=1

    graphxy,iout,xvec,yvec,isym,ndist,labelx,labely,title,$
    xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

   endfor
; loop over ii
; *****

  endfor
; Loop over the size distributions is done
; *****

; Close the ps device
   device,/close

   print,'  output ps file is located at ',fileps

; *****
  return
  end
