   pro rdwagner_sahara_dust,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; Note that there is only one wavelength (523 nm)

; ***
; The input netCDF file
  fil=strarr(1)
  fil='wagner_sahara_dust.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnwav=ncdf_varid(nc_id,'nwav')
  idncases=ncdf_varid(nc_id,'ncases')
  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idhematite=ncdf_varid(nc_id,'hematite')
  idrefn=ncdf_varid(nc_id,'refn')
  idrefi=ncdf_varid(nc_id,'refi')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idncases,ncases
  ncdf_varget,nc_id,idnwav,nwav
  ncdf_varget,nc_id,idwcm,wcm2
  ncdf_varget,nc_id,idwavelength,wavelength2
  ncdf_varget,nc_id,idhematite,hematite
  ncdf_varget,nc_id,idrefn,refn
  ncdf_varget,nc_id,idrefi,refi

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
  for i=9,14 do begin  
   print,text(i)
  endfor

; Specify the set to work with
  print,' specify iset 0 to 4 '
  read,iset

; *****
; For the graphs (oops, but there is only one wavelength)
  text2=strarr(5)
  str2=strarr(1)
   iadd=10
   nstart=8
   npos=12
  for i=0,4 do begin
   ii=i+iadd
   str2=strmid(text(ii),nstart,npos)
   text2(i)=str2
  endfor

; *****
; Note that you only read in the data for which the real and imaginary
; parts are both specified
    nlines=nwav
   rndat=fltarr(nlines)
   ridat=fltarr(nlines)
   wcm=fltarr(nlines)
   wavelength=fltarr(nlines)

; **
; Specify the output values
   for i=0,nlines-1 do begin
    rndat(i)=refn(i,iset)
    ridat(i)=refi(i,iset)
    wcm(i)=wcm2(i)
    wavelength(i)=wavelength2(i)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+text2(iset))

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdwagner_sahara_dust: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdwagner_sahara_dust: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


