   pro rdtoon_psc,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='toon_psc.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')

  idnbetanat=ncdf_varid(nc_id,'nbetanat')
  idnnad=ncdf_varid(nc_id,'nnad')
  idnalphanat=ncdf_varid(nc_id,'nalphanat')
  idnnam=ncdf_varid(nc_id,'nnam')
  idnice163=ncdf_varid(nc_id,'nice163')
  idnanat=ncdf_varid(nc_id,'nanat')
  idnanad=ncdf_varid(nc_id,'nanad')
  idnanam=ncdf_varid(nc_id,'nanam')

  idwcmbetanat=ncdf_varid(nc_id,'wcmbetanat')
  idwcmnad=ncdf_varid(nc_id,'wcmnad')
  idwcmalphanat=ncdf_varid(nc_id,'wcmalphanat')
  idwcmnam=ncdf_varid(nc_id,'wcmnam')
  idwcmice163=ncdf_varid(nc_id,'wcmice163')
  idwcmanat=ncdf_varid(nc_id,'wcmanat')
  idwcmanad=ncdf_varid(nc_id,'wcmanad')
  idwcmanam=ncdf_varid(nc_id,'wcmanam')

  idwmicbetanat=ncdf_varid(nc_id,'wmicbetanat')
  idwmicnad=ncdf_varid(nc_id,'wmicnad')
  idwmicalphanat=ncdf_varid(nc_id,'wmicalphanat')
  idwmicnam=ncdf_varid(nc_id,'wmicnam')
  idwmicice163=ncdf_varid(nc_id,'wmicice163')
  idwmicanat=ncdf_varid(nc_id,'wmicanat')
  idwmicanad=ncdf_varid(nc_id,'wmicanad')
  idwmicanam=ncdf_varid(nc_id,'wmicanam')

  idrnbetanat=ncdf_varid(nc_id,'rnbetanat')
  idrnnad=ncdf_varid(nc_id,'rnnad')
  idrnalphanat=ncdf_varid(nc_id,'rnalphanat')
  idrnnam=ncdf_varid(nc_id,'rnnam')
  idrnice163=ncdf_varid(nc_id,'rnice163')
  idrnanat=ncdf_varid(nc_id,'rnanat')
  idrnanad=ncdf_varid(nc_id,'rnanad')
  idrnanam=ncdf_varid(nc_id,'rnanam')

  idribetanat=ncdf_varid(nc_id,'ribetanat')
  idrinad=ncdf_varid(nc_id,'rinad')
  idrialphanat=ncdf_varid(nc_id,'rialphanat')
  idrinam=ncdf_varid(nc_id,'rinam')
  idriice163=ncdf_varid(nc_id,'riice163')
  idrianat=ncdf_varid(nc_id,'rianat')
  idrianad=ncdf_varid(nc_id,'rianad')
  idrianam=ncdf_varid(nc_id,'rianam')

  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70

  ncdf_varget,nc_id,idnbetanat,nbetanat
  ncdf_varget,nc_id,idnnad,nnad
  ncdf_varget,nc_id,idnalphanat,nalphanat
  ncdf_varget,nc_id,idnnam,nnam
  ncdf_varget,nc_id,idnice163,nice163
  ncdf_varget,nc_id,idnanat,nanat
  ncdf_varget,nc_id,idnanad,nanad
  ncdf_varget,nc_id,idnanam,nanam

  ncdf_varget,nc_id,idwcmbetanat,wcmbetanat
  ncdf_varget,nc_id,idwcmnad,wcmnad
  ncdf_varget,nc_id,idwcmalphanat,wcmalphanat
  ncdf_varget,nc_id,idwcmnam,wcmnam
  ncdf_varget,nc_id,idwcmice163,wcmice163
  ncdf_varget,nc_id,idwcmanat,wcmanat
  ncdf_varget,nc_id,idwcmanad,wcmanad
  ncdf_varget,nc_id,idwcmanam,wcmanam

  ncdf_varget,nc_id,idwmicbetanat,wmicbetanat
  ncdf_varget,nc_id,idwmicnad,wmicnad
  ncdf_varget,nc_id,idwmicalphanat,wmicalphanat
  ncdf_varget,nc_id,idwmicnam,wmicnam
  ncdf_varget,nc_id,idwmicice163,wmicice163
  ncdf_varget,nc_id,idwmicanat,wmicanat
  ncdf_varget,nc_id,idwmicanad,wmicanad
  ncdf_varget,nc_id,idwmicanam,wmicanam

  ncdf_varget,nc_id,idrnbetanat,rnbetanat
  ncdf_varget,nc_id,idrnnad,rnnad
  ncdf_varget,nc_id,idrnalphanat,rnalphanat
  ncdf_varget,nc_id,idrnnam,rnnam
  ncdf_varget,nc_id,idrnice163,rnice163
  ncdf_varget,nc_id,idrnanat,rnanat
  ncdf_varget,nc_id,idrnanad,rnanad
  ncdf_varget,nc_id,idrnanam,rnanam

  ncdf_varget,nc_id,idribetanat,ribetanat
  ncdf_varget,nc_id,idrinad,rinad
  ncdf_varget,nc_id,idrialphanat,rialphanat
  ncdf_varget,nc_id,idrinam,rinam
  ncdf_varget,nc_id,idriice163,riice163
  ncdf_varget,nc_id,idrianat,rianat
  ncdf_varget,nc_id,idrianad,rianad
  ncdf_varget,nc_id,idrianam,rianam

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Specify which set to work with
  print,'  Toon PSC indices '
  print,'  iset=0,1,2,3,4 for betanat, nad, alphanat, nam, ice163'
  print,'  iset=5,6,7 for anat, anad, anam '
  print,'  Specify iset, 0 to 7'

  read,iset

  lines2=intarr(8)
  lines2(0)=nbetanat
  lines2(1)=nnad
  lines2(2)=nalphanat
  lines2(3)=nnam
  lines2(4)=nice163
  lines2(5)=nanat
  lines2(6)=nanad
  lines2(7)=nanam

  nlines=intarr(1)
  nlines=lines2(iset)
  i1=0
  i2=nlines(0)-1
  nlines=i2+1

  rndat=fltarr(nlines)
  ridat=fltarr(nlines)
  wcm=fltarr(nlines)
  wavelength=fltarr(nlines)

; **
  if (iset eq 0) then begin
   for i=i1,i2 do begin
    rndat(i)=rnbetanat(i)
    ridat(i)=ribetanat(i)
    wcm(i)=wcmbetanat(i)
    wavelength(i)=wmicbetanat(i)
   endfor
   casestr=' betanat '
   goto,jump1
  endif

  if (iset eq 1) then begin
   for i=i1,i2 do begin
    rndat(i)=rnnad(i)
    ridat(i)=rinad(i)
    wcm(i)=wcmnad(i)
    wavelength(i)=wmicnad(i)
   endfor
   casestr=' nad '
   goto,jump1
  endif

  if (iset eq 2) then begin
   for i=i1,i2 do begin
    rndat(i)=rnalphanat(i)
    ridat(i)=rialphanat(i)
    wcm(i)=wcmalphanat(i)
    wavelength(i)=wmicalphanat(i)
   endfor
   casestr=' alphanat'
   goto,jump1
  endif

  if (iset eq 3) then begin
   for i=i1,i2 do begin
    rndat(i)=rnnam(i)
    ridat(i)=rinam(i)
    wcm(i)=wcmnam(i)
    wavelength(i)=wmicnam(i)
   endfor
   casestr=' nam '
   goto,jump1
  endif

  if (iset eq 4) then begin
   for i=i1,i2 do begin
    rndat(i)=rnice163(i)
    ridat(i)=riice163(i)
    wcm(i)=wcmice163(i)
    wavelength(i)=wmicice163(i)
   endfor
   casestr=' ice 163K '
   goto,jump1
  endif

  if (iset eq 5) then begin
   for i=i1,i2 do begin
    rndat(i)=rnanat(i)
    ridat(i)=rianat(i)
    wcm(i)=wcmanat(i)
    wavelength(i)=wmicanat(i)
   endfor
   casestr=' anat '
   goto,jump1
  endif

  if (iset eq 6) then begin
   for i=i1,i2 do begin
    rndat(i)=rnanad(i)
    ridat(i)=rianad(i)
    wcm(i)=wcmanad(i)
    wavelength(i)=wmicanad(i)
   endfor
   casestr=' anad '
   goto,jump1
  endif

  if (iset eq 7) then begin
   for i=i1,i2 do begin
    rndat(i)=rnanam(i)
    ridat(i)=rianam(i)
    wcm(i)=wcmanam(i)
    wavelength(i)=wmicanam(i)
   endfor
   casestr=' anam '
   goto,jump1
  endif

  jump1:mn=0

; ***
   lset=strcompress(lstrn+casestr)

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdtoon_psc: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdtoon_psc: i,wcm,wavelength,rndat and ridat'
   for i=i1,i2 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


