   pro rdmyhre_hno3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='myhre_hno3.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnumlinesr=ncdf_varid(nc_id,'numlinesr')
  idnumlinesi=ncdf_varid(nc_id,'numlinesi')
  idncases=ncdf_varid(nc_id,'ncases')
  idntempmax=ncdf_varid(nc_id,'ntempmax')
  idwhno3=ncdf_varid(nc_id,'whno3')
  idtemps=ncdf_varid(nc_id,'temps')
  idntemps=ncdf_varid(nc_id,'ntemps')
  idwcmr=ncdf_varid(nc_id,'wcmr')
  idwavelengthr=ncdf_varid(nc_id,'wavelengthr')
  idrn=ncdf_varid(nc_id,'rn')
  idwcmi=ncdf_varid(nc_id,'wcmi')
  idwavelengthi=ncdf_varid(nc_id,'wavelengthi')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnumlinesr,numlinesr
  ncdf_varget,nc_id,idnumlinesi,numlinesi
  ncdf_varget,nc_id,idncases,ncases
  ncdf_varget,nc_id,idwhno3,whno3
  ncdf_varget,nc_id,idntemps,ntemps
  ncdf_varget,nc_id,idtemps,temps
  ncdf_varget,nc_id,idwcmr,wcmr
  ncdf_varget,nc_id,idwavelengthr,wavelengthr
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idwcmi,wcmi
  ncdf_varget,nc_id,idwavelengthi,wavelengthi
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  myhre hno3'
  print,'  ncases ',ncases
  print,'  ntemps ',ntemps
  print,'  The table to choose from'
  for i=0,ncases-1 do begin
    nval=ntemps(i)
   vec1=fltarr(nval)
   vec2=fltarr(nval)
   for j=0,nval-1 do begin
    vec1(j)=temps(i,j)
    vec2(j)=whno3(i)
   endfor
   print,'  '
   print,'  ',vec1
   print,'  ',vec2
  endfor

; *****
   print,'  '
   print,'  specify temperature and hno3 pair (e.g. 273.0, 54.0)
   print,'  specify temp'
   read,temp
   print,'  specify hno3'
   read,hno3

    diffmin=1.0e6
    ival=-99
    jval=-99
    icase=-99
   for i=0,ncases-1 do begin
    nval=ntemps(i)
   for j=0,nval-1 do begin
    diff1=temp-temps(i,j)
    diff2=hno3-whno3(i)
    diff=sqrt((diff1*diff1)+(diff2*diff2))
    if (diff lt diffmin) then begin  
     ival=i
     jval=j
     icase=i
     diffmin=diff
    endif
   endfor
   endfor

   if ((ival lt 0) or (jval lt 0)) then begin
    print,'  '
    print,'  rdmyhre_hno3: icase ',icase
    print,'  rdmyhre_hno3: ival,jval ',ival,jval
    print,'  rdmyhre_hno3: ival or jval lt 0, will stop'
    stop
   endif

; **
   tempstr=strarr(1)
   tempstr=string(fix(temps(ival,jval)))
   hno3=strarr(1)
   hno3=string(fix(whno3(ival)))

; **
     nlines=fix(numlinesr(icase))
    numr=fix(numlinesr(icase))
    numi=fix(numlinesr(icase))
    if (numr ne numi) then begin
     print,'  '
     print,'  rdmyhre: numr,numi ',numr,numi 
     print,'  rdmyhre: numr ne numi, will stop'
     stop
    endif

    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)

    print,'  '
    print,'  rdmyhre: nlines,temp,temps(ival,jval) '
    print,'  ',nlines,temp,temps(ival,jval)
    print,'  rdmyhre: nlines,hno3,whno3(ival) '
    print,'  ',nlines,hno3,whno3(ival)

    printf,iout,'  '
    printf,iout,'  rdmyhre: nlines,temp,temps(ival,jval) '
    printf,iout,'  ',nlines,temp,temps(ival,jval)
    printf,iout,'  rdmyhre: nlines,hno3,whno3(ival) '
    printf,iout,'  ',nlines,hno3,whno3(ival)

; **
; Specify the output values
; wcmr and wcmi are the same 
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,icase,ival)
    ridat(i)=ri(i,icase,ival)
    wcm(i)=wcmr(i,icase)
    wavelength(i)=wavelengthr(i,icase)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+tempstr+' K '+hno3+' %')

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdmyhre_hno3: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdmyhre_hno3: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


