   pro rdhashemivan,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rndat,ridat,rnerr,rierr

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file is filnm

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnfiles=ncdf_varid(nc_id,'nfiles')
  idnwave=ncdf_varid(nc_id,'nwave')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

  idtext=ncdf_varid(nc_id,'text')
  idvanstrs=ncdf_varid(nc_id,'vanstrs')

  idn70=ncdf_varid(nc_id,'n70')
  idn13=ncdf_varid(nc_id,'n13')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn13,n13
  ncdf_varget,nc_id,idnfiles,nfiles
  ncdf_varget,nc_id,idnwave,nwave

  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

  text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; vanstrs=strarr(n13)
; ncdf_varget,nc_id,idvanstrs,vanstrs
; vanstrs=string(vanstrs)

   vanstrs=strarr(nfiles)
   vanstrs2=strarr(nfiles)
;           '1234567890123'
   vanstrs=['vanillic acid']
   vanstrs2=['vanillic acid']

; ****
; Close the data set
  ncdf_close,nc_id

; ****
   ihelp=0
  if (ihelp eq 1) then begin
   help,rn
   help,ri
   help,wcm
   help,wavelength
   help,nwave
   help,ntext
   help,text
   help,vanstrs
   help,vanstrs2
   stop
; RN              FLOAT     = Array[65]
; RI              FLOAT     = Array[65]
; WCM             FLOAT     = Array[65]
; WAVELENGTH      FLOAT     = Array[65]
; NWAVE           INT       =       65
; NTEXT           INT       =       14
; TEXT            STRING    = Array[14]
; VANSTRS         STRING    = Array[1]
; VANSTRS2        STRING    = Array[1]
  endif

; *****
  print,'  '
  print,'  Hashemi vanillic acid'

; ***
   text2=string(vanstrs)
;  lset=strcompress(lstrn+text2)

; *****
; Output values
   nlines=nwave

; Specify the indices
    jval=0
    rndat=fltarr(nwave)
    ridat=fltarr(nwave)
; have 0.0
    rnerr=fltarr(nwave)
    rierr=fltarr(nwave)
   for i=0,nwave-1 do begin
    rndat(i)=rn(i)
    ridat(i)=ri(i)
   endfor

; *****
     ntext=14
    text=strarr(ntext)

;           '1234567890123456789012345678901234567890123456789012345678901234567890'
    text(0)='                                                                      '
    text(1)='  Data: Real and imaginary indices of vanillic acid aerosol           '
    text(2)='  from 0.27 to 0.6 microns                                            '
    text(3)='                                                                      '
    text(4)='  Reference: Hashemi V, Galpin T Greenslade M                         '
    text(5)='  Complex refractive index of vanillic acid aerosol retrieved from    '
    text(6)='  from 270–600 nm using aerosol extinction and solution phase         '
    text(7)='  absorption measurements                                             '
    text(8)='  Aer Sci Tech, 2024;58(5):569-83                                     '

; Hosseinpour Hashemi, V., Galpin, T. and Greenslade, M.E., 2024. Complex refractive index of vanillic acid aerosol retrieved from 270–600 nm using aerosol extinction and solution phase absorption measurements. Aerosol Science and Technology, 58(5), pp.569-583.

    text(9)='                                                                      '
    text(10)='  Email contact: M. Greenslade (margaret.e.greenslade@gmail.com)      '
    text(11)='                                                                      '
    text(12)='  Format: 65 real indices (2x,f8.2,2x,f10.4,1(2x,f5.3))               '
    text(13)='          65 imaginary indices (2x,f8.2,2x,f10.4,1(1x,e10.3))         '

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  hashemivan: filnm ',filnm
    printf,iout,'  '
    printf,iout,'  hashemivan: next ',ntext
    printf,iout,'  hashemivan: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  hashemivan: nwave ',nwave
   printf,iout,'  hashemivan: vanstrs ',vanstrs
   printf,iout,'  hashemivan: i,wcm,wavelength,rndat and ridat'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
