   pro rdgrainger,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rn,ri,rnerr,rierr

; ******
; Read in the data from the netCDF file

; ****
; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlines=ncdf_varid(nc_id,'nlines')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')

  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idrnerr=ncdf_varid(nc_id,'rnerr')
  idrierr=ncdf_varid(nc_id,'rierr')

  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnlines,nlines
  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri
  ncdf_varget,nc_id,idrnerr,rnerr
  ncdf_varget,nc_id,idrierr,rierr

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdgrainger: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdgrainger: i,wcm,wavelength,rn,rierr,ri,rierr,'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rn(i),rnerr(i),ri(i),rierr(i)
   endfor

  endif

; ******
  return
  end


