; Open an output ascii file
   iout=20
  openw,iout,'f.out'

; *************************
  printf,iout,'  '
  printf,iout,'  main: HITRAN-Refractive-Indices program'

; *************************
; Read in the specifications of the input refractive index and output
; subdirectory to which output text and ps graphs are written to
; Information is supplied by the user in the    directory.dat   file
    nopr=1
   rdinoutdir,nopr,$
   iout,indir,outdir,fout,$
   dircompare,$
   dirusersizedist,$
   diruserindices,$
   dirmultisets

; *************************
; Read in from the 
; Information is supplied by the user in the    work.dat   file
   rdwork,noprwork,$
   noprtest,noprlist,noprind,$
   noprwave,noprsize,noprext,$
   iout,indir,outdir,fout,$
   itest,iset,igraphi,igraphd,igraphe,$
   iwrind,iwrsize,iwrext,$
   iuser_sizedist,$
   iuser_indices,$
   iuser_calc,$
   iwave,w1,w2,dw,r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   icompare,iset1,iset2,$
   icompare_spectra,$
   imultisetsgraph,$
   imix,imix1,imix2

; *************************
; Read in the listing of refractive index sets
; from the   indices.dat  ascii listing 
   if (iuser_indices ne 1) then begin
    rdlistrn,noprlist,iout,$
    nsets,listrn
   endif

; *************************
; Case studies for instructional purposes

; Work with particle size distributions
  if (itest eq 1) then begin
   test1,noprtest,$
   iout,indir,outdir,fout
   print,'  test case 1 completed, will stop'
   stop
  endif

; Q versus size parameter x calculations
  if (itest eq 2) then begin
   test2,noprtest,$
   iout,indir,outdir,fout
   print,'  test case 2 completed, will stop'
   stop
  endif

; See how the extinction spectrum changes as the size distribution widens
  if (itest eq 3) then begin
   test3,noprtest,$
   iout,indir,outdir,fout
   print,'  test case 3 completed, will stop'
   stop
  endif

; See how the extinction spectrum changes as you add a coating to a particle
  if (itest eq 4) then begin
   test4,noprtest,$
   iout,indir,outdir,fout
   print,'  test case 4 completed, will stop'
   stop
  endif

; *************************
; Compare several sets of indices
  if (imultisetsgraph eq 1) then begin
   multisetsgraph,nopr,iout,$
   dirmultisets,outdir
   print,'  graphed multiple sets of indices with imultisetsgraph=1, will stop'
   stop
  endif

; *************************
; For iuser_calc eq 1 the user writes    user.pro   and does a
; specific calculation
  if (iuser_calc eq 1) then begin

; indices are for set iset (see indices.dat)
    noprind=0
   rdindices,noprind,iout,$
   indir,$
   iset,igraphi,$
   nsets,listrn,lstrn,$
   nlines,wcm,wavelength,rndat,ridat,$
   outdir,iwave,iwrind,lset,ibothpos

; Calculate the wavelength or wavenumber range to work with
    noprwave=0
   calcwave,noprwave,iout,$
   nlines,wcm,wavelength,rndat,ridat,$
   iwave,w1,w2,dw,$
   nwave,wave,rn,ri,$
   outdir,igraphi,iwrind,lset,lstrn,$
   ibothpos

; User writes   user.pro   and does a specific set of calculations
; Include nwave,wave,rn,ri as input to user.pro
    nopru=1
   user,nopru,iout,$
   iwave,w1,w2,dw,$
   outdir,lset,$
   nwave,wave,rn,ri

   printf,iout,'  '
   printf,iout,'  main: user.pro calculation is done'
   stop

   endif
; iuser_calc eq 1

; *************************
; Compare two sets of indices
  if (icompare eq 1) then begin
   compareindx,nopr,iout,$
   icompare,iset1,iset2,$
   nsets,listrn,lstrn,$
   indir,outdir,iwave,w1,w2
   print,'  compared indices with icompare=1, will stop'
   stop
  endif

; *************************
; Compare two spectra
  if (icompare_spectra eq 1) then begin
   compare_spectra,nopr,iout,$
   dircompare,$
   icompare_spectra
   print,'  compared spectra with icompare_spectra=1, will stop'
   stop
  endif

; *************************
; Compare mixing rules
  if (imix eq 1) then begin
   comparemix,nopr,iout,$
   imix,imix1,imix2,$
   nsets,listrn,lstrn,$
   indir,outdir,iwave,w1,w2
   print,'  compared mixing rules with imix=1, will stop'
   stop
  endif

; *************************
; Read in the indices of refraction for set iset
; Will interpolate to the output wave spectra grid with nwave points
; For igraphi will graph the real and imaginary indices of refraction

  if (iuser_indices ne 1) then begin

   rdindices,noprind,iout,$
   indir,$
   iset,igraphi,$
   nsets,listrn,lstrn,$
   nlines,wcm,wavelength,rndat,ridat,$
   outdir,iwave,iwrind,lset,ibothpos

; To indicate in the ps file title that this 
; graph is from idl_calc program, use the the next line
;  lset=strcompress(lset+' idl')
   lset=strcompress(lset)

; Obtain the wavenumber (or wavelength) scale
; Will use interpolation to obtain rn and ri indices

   calcwave,noprwave,iout,$
   nlines,wcm,wavelength,rndat,ridat,$
   iwave,w1,w2,dw,$
   nwave,wave,rn,ri,$
   outdir,igraphi,iwrind,lset,lstrn,$
   ibothpos

   endif
; iuser_indices ne 1

; *************************
; Calculate the size distribution with ndist points
  if (iuser_sizedist ne 1) then begin

   lsetsz='standard dist'

   calcsized,noprsize,iout,$
   r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   ndist,radr,sized,$
   outdir,igraphd,iwrsize,$
   lsetsz

  endif
; iuser_sizedist ne 1

; *************************
; Read in the user specified refractive indices
; Will also specify the wavelength scale
  if (iuser_indices eq 1) then begin
    nopruser=1
   rduser_indices,nopruser,iout,$
   diruserindices,$
   iwave,w1,w2,dw,$
   nwave,wave,rn,ri,$
   outdir,igraphi,iwrind,lset,lstrn,$
   ibothpos
  endif

; *************************
; Read in the user specified size distribution
  if (iuser_sizedist eq 1) then begin
    nopruser=1
   rduser_sizedist,nopruser,iout,$
   dirusersizedist,$
   ndist,radr,sized,$
   outdir,igraphd,iwrsize
  endif

; *************************
  if (iuser_sizedist eq 1) then begin
   lset='user specified size dist'
  endif
  if (iuser_indices eq 1) then begin
   lset='user specified indices'
  endif
  if ((iuser_indices eq 1) and (iuser_sizedist eq 1)) then begin
   lset='user specified size dist, indices '
  endif

; *************************
; Calculate the spectra (extinction, absorption, scattering, single scattering
; albedo, and asymmetry parameter)
   ngraph=0
   nlast=1
  calcext,noprext,iout,$
  iwave,nwave,wave,rn,ri,$
  ndist,radr,sized,$
  bext,babs,bsca,asym,back,omega,$
  outdir,igraphe,iwrext,lset,$
  ngraph,nlast

; *************************
; Close the f.out file
  close,iout

; *************************
  stop
  end
