  subroutine rdwagner_supercooled(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=442,nt=4
  integer :: ntk(nt)
  real :: wcmdat(ndat),wavedat(ndat)
! Note that the ndat,nt is opposite to the ncdump dump
  real :: rnval(ndat,nt),rival(ndat,nt)
  character(len=60) :: fil
  character (len=16) :: llset,files(nt)

! **********
! The four temperatures of interest
  ntk(1)=238
  ntk(2)=252
  ntk(3)=258
  ntk(4)=269
!         '1234567890123456'
  files(1)='Wagner 238 K   '
  files(2)='Wagner 252 K   '
  files(3)='Wagner 258 K   '
  files(4)='Wagner 269 K   '

! ***
! Will specify which temperature to work with

  write(0,fmt=140)
  140 format(2x," Will select itemp=1,2,3,4 for 238, 252, 258 or 269 K ")

  write(0,fmt=160)
  160 format(2x,"Specify itemp ")

  read(5,*) itemp
  itemp=int(itemp)

  if (itemp .gt. 4) then
  write(0,fmt=165)
  165 format(2x," itemp gt 4, will stop")
   stop
  end if

! The compound string
  llset=files(itemp)

  write(0,fmt=170) itemp,llset
  170 format(2x," itemp,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/wagner_supercooled.dat                         '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

!  Data: Real and imaginary indices of supercooled water
!  at 238, 252, 258, and 269 K from 1101 to 4503 cm-1
!
!  Reference: Wagner,R., S. Benz, O. Muhler, H. Saathoff, M. Schnaiter,
!  and U. Schurath, Mid-Infrared Extinction Spectra and Optical
!  Constants of Supercooled Water Droplets, J. Phys. Chem., volume 109,
!  pgs. 7099-7112, 2005.
!
!  Email contact person: Robert Wagner (Robert.Wagner@imk.fzk.de)
!
!  Format: 442 real indices (2x,f7.2,2x,f10.4,4(2x,f7.5))
!          442 imaginary indices (2x,f7.2,2x,f10.4,4(1x,e11.4))
!
!  cm-1        microns  real238, real252, real258, real269,
!  4503.04      2.2207  1.28210  1.28723  1.28864  1.29003
!  4495.33      2.2245  1.28177  1.28694  1.28833  1.28973

! ***
! Read in the ascii file data

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

   do i=1,14
    read(idat,fmt=100) header
   end do
   100 format(a80)

   nlines=ndat

   do i=1,442
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,4)
   end do

   do i=1,2
    read(idat,fmt=100) header
   end do

   do i=1,442
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,4)
   end do

! Close the input ascii file
   close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,itemp)
   ridat(i)=rival(i,itemp)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=839) itemp,files(itemp)
    839 format(/,2x,"rdwagner_supercooled: itemp,files(itemp) ",i3,2x,a16)
    write(iout,fmt=840)
    840 format(2x,"rdwagner_supercooled: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
