  subroutine rdmyhre_organic_acids(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=1001,ncomp=21
  integer,parameter :: ndatr=1001,ndati=851
  integer,parameter :: npairs=10
  integer :: noprf,mset,i1,i2
  integer :: ireal(npairs),iimag(npairs)
  real :: numlines(ncomp)
  real :: wcmdatr(ndatr,ncomp),wavedatr(ndatr,ncomp)
  real :: wcmdati(ndati,ncomp),wavedati(ndati,ncomp)
  real :: rnval(ndatr,ncomp),rival(ndati,ncomp)
  character(len=60) :: fil
  character (len=40) :: files(ncomp)
  character (len=60) :: filesd(ncomp)
  character (len=16) :: llset

  real :: wcmr(ndatr),wavelengthr(ndatr)
  real :: wcmi(ndati),wavelengthi(ndati)

  data numlines/851, 851, 1001,1001,1001,851, 851, 1001,1001,1001,851, &
                1001,1001,851, 851,851, 1001,851, 1001,851,851 /
  data ireal/3,4,5, 8,9,10,   12,13,  17,  19 /
  data iimag/6,6,6, 11,11,11, 14,14,  18,  20 /

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456789012345678901234567890'
  files(1)='Imaginary indices of ammoniumsulfate    '
  files(2)='Imaginary indices of benzoic acid       '
  files(3)='Real indices of 25 wt% Glutaric acid    '
  files(4)='Real indices of 50 wt% Glutaric acid    '
  files(5)='Real indices of 5 wt% Glutaric acid     '
  files(6)='Imaginary indices of glutaric acid K    '
  files(7)='Imaginary indices of hydroxymalonic acid' 
  files(8)='Real indices of 10 wt% Malonic acid     '
  files(9)='Real indices of 25 wt% Malonic acid     '
  files(10)='Real indices of 60 wt% Malonic acid    '
  files(11)='Imaginary indices of malonic acid      '
  files(12)='Real indices of 10 wt% Oxalic acid     '
  files(13)='Real indices of 5 wt% Oxalic acid      '
  files(14)='Imaginary indices of oxalic acid       '
  files(15)='Imaginary indices of phthalic acid     '
  files(16)='Imaginary indices of pinonic acid      '
  files(17)='Real indices of 5 wt% Pyruvic acid     '
  files(18)='Imaginary indices of pyruvic acid      '
  files(19)='Real indices of 8 wt% Succinic acid    '
  files(20)='Imaginary indices of succinic acid     '
  files(21)='Imaginary indices of water at 293K     '

!           '123456789012345678901234567890123456789012345678901234567890'
  filesd(1)='organic_acids/ammoniumsulfate_imag.myhre                    '
  filesd(2)='organic_acids/benzoic_imag.myhre                            '
  filesd(3)='organic_acids/glutaric_25%_real.myhre                       '
  filesd(4)='organic_acids/glutaric_50%_real.myhre                       '
  filesd(5)='organic_acids/glutaric_5%_real.myhre                        '
  filesd(6)='organic_acids/glutaric_imag.myhre                           '
  filesd(7)='organic_acids/hydroxymalonic_imag.myhre                     '
  filesd(8)='organic_acids/malonic_10%_real.myhre                        '
  filesd(9)='organic_acids/malonic_25%_real.myhre                        '
  filesd(10)='organic_acids/malonic_60%_real.myhre                       '
  filesd(11)='organic_acids/malonic_imag.myhre                           '
  filesd(12)='organic_acids/oxalic_10%_real.myhre                        '
  filesd(13)='organic_acids/oxalic__5%_real.myhre                        '
  filesd(14)='organic_acids/oxalic_imag.myhre                            '
  filesd(15)='organic_acids/phthalic_imag.myhre                          '
  filesd(16)='organic_acids/pinonic_imag.myhre                           '
  filesd(17)='organic_acids/pyruvic_5%_real.myhre                        '
  filesd(18)='organic_acids/pyruvic_imag.myhre                           '
  filesd(19)='organic_acids/succinic_8%_real.myhre                       '
  filesd(20)='organic_acids/succinic_imag.myhre '
  filesd(21)='organic_acids/water_imag.myhre'

! *
  nlines=-999
  nlinesr=-999
  nlinesi=-999

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific case")
  write(0,fmt=145)
  145 format(2x," i, case ")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a40)
  end do

  write(0,fmt=146)
  146 format(2x," To obtain a pair of indices (real and imaginary) ",&
   /,2x," Set mset to 3,4,5 8,9,10, 12,13, 17, or 19")

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-21) ")

  read(5,*) mset
  mset=int(mset)

! The compound string
!       '1234567890123456'
  llset=' Myhre organic  '

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! loop over the files, will read in all of the data
  do j=1,ncomp 

! The input ascii file
  fil=filesd(j)

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! Open input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,12
   read(idat,fmt=100) header
  end do
  100 format(a80)

! The number of lines to work with
   nlines=numlines(j)
!  write(iout,fmt=190) j,nlines 
!  190 format(/,2x,"j,nlines ",i2,2x,i4)

! Note that the wcmdatr and wcmdati are different
   if (nlines .eq. ndatr) then 
    do i=1,ndatr
     read(idat,*) wcmdatr(i,j),wavedatr(i,j),rnval(i,j)
    end do
   end if

   if (nlines .eq. ndati) then 
    do i=1,ndati
     read(idat,*) wcmdati(i,j),wavedati(i,j),rival(i,j)
    end do
   end if

  end do

  close (idat)

! ***
! Now you need to combine the two sets of real and imaginary indices in order
! to do a Mie calculation
    ipair=-99
   do i=1,npairs
    if (mset .eq. ireal(i)) then 
     ipair=iimag(i)
    end if
   end do

! ***
! Pair not found
   if (ipair .lt. 0) then 
     write(iout,fmt=188) mset
     188 format(/,2x,"oops, will stop,  mset= ",i4)
     write(0,fmt=188) mset
     stop
    end if

! ***
! Pair found
   if (ipair .gt. 0) then 

   write(iout,fmt=192) mset,ipair
   192 format(/,2x,"File with real indices, mset= ",i4,&
   /,2x,"ipair= ",i4)

    fil=filesd(mset)
     noprf=1
    call getfilnm(noprf,iout,fil,indir,filnm)
    if (noprf .eq. 1) then
!    stop
    end if

   write(iout,fmt=194) ipair
   194 format(/,2x,"File with imaginary indices, ipair= ",i4)

    fil=filesd(ipair)
     noprf=1
     call getfilnm(noprf,iout,fil,indir,filnm)
    if (noprf .eq. 1) then
!    stop
    end if

! ***
! Pair not found
   if (ipair .lt. 0) then 
    write(iout,fmt=196)
    196 format(/,2x,"Real nd imaginary file pair not found, will stop")
     stop
   endif

! ***
    nlinesr=ndatr
  do i=1,nlinesr
   wcmr(i)=wcmdatr(i,mset)
   wavelengthr(i)=wavedatr(i,mset)
   rndat(i)=rnval(i,mset)
  end do

    nlinesi=ndati
  do i=1,nlinesi
   wcmi(i)=wcmdati(i,ipair)
   wavelengthi(i)=wavedati(i,ipair)
   ridat(i)=rival(i,ipair)
  end do

! **
! nlinesr is bad
   if (nlinesr .lt. 0) then 
    write(iout,fmt=197) nlinesr
    197 format(/,2x,"rdmyhre_organic_acids: nlinesr ",i4,"  will stop")
    write(0,fmt=197) nlinesr
     stop
   endif

! nlinesi is bad
   if (nlinesi .lt. 0) then 
    write(iout,fmt=199) nlinesi
    199 format(/,2x,"rdmyhre_organic_acids: nlinesi ",i4,"  will stop")
    write(0,fmt=199) nlinesi
     stop
   endif

! **
! Put data into same wavelength grid
    noprs=0
   call samewave(noprs,iout,&
   nlines,wcm,wavelength,&
   nlinesr,wcmr,wavelengthr,rndat,&
   nlinesi,wcmi,wavelengthi,ridat)

   end if
! ipair gt 0

! **
! nlines is bad
   if (nlines .lt. 0) then 
    write(iout,fmt=201) nlines
    201 format(/,2x,"rdmyhre_organic_acids: nlines ",i4,"  will stop")
    write(0,fmt=201) nlines
     stop
   endif

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdmyhre_organic_acids: work with mset, files(mset)",/,&
    2x,i3,2x,a40)
    write(iout,fmt=840) nlines
    840 format(2x,"rdmyhre_organic_acids: nlines ",i4,/,&
    2x,"rdmyhre_organic_acids: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
