  subroutine rdbiermann_hno3(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,&
  nlinesr,wcmr,wavelengthr,rndat,&
  nlinesi,wcmi,wavelengthi,ridat,&
  ndifferent,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Case here where number of real and imaginary indices differs
  real :: wcmr(nwavemax),wavelengthr(nwavemax)
  real :: wcmi(nwavemax),wavelengthi(nwavemax)

! Used here
! Notice that the exact number of elements in rnval,rival works
  integer,parameter :: ndatr=8192,ndati=4768,mtempmax=7,nwt=7
  integer :: i,mn,nc
  integer :: ival,jval
  integer :: nlinesr,nlinesi
  real :: a1,a2
  real :: wghthno3
  real :: vec1(nwt),vec2(nwt)
  integer :: ivec1(nwt),ivec2(nwt)
  real :: diff1,diff2
! Note that the ndat,mtemp is opposite to the ncdump dump
  integer :: nhno3(mtempmax)
  real :: temps(mtempmax)
  real :: numlinesr(mtempmax),numlinesi(mtempmax)
  real :: whno3(mtempmax,nwt)
  real :: rndatn(ndatr,mtempmax,nwt)
  real :: ridatn(ndati,mtempmax,nwt)
  real :: wcmr2(ndatr)
  real :: waver2(ndatr)
  real :: rn(ndatr)
  real :: wcmi2(ndati)
  real :: wavei2(ndati)
  real :: ri(ndati)

  character(len=60) :: fil
  character (len=16) :: llset
  character (len=60) :: files(mtempmax)

! ***
   data temps/213.0, 223.0, 233.0, 253.0, 263.0, 273.0, 293.0 /
   data nhno3/2,3,4,4,2,7,7/
   ntemps=7

   nlinesr=ndatr
   nlinesi=ndati

! file1
   whno3(1,1)=40.0
   whno3(1,2)=45.0
! file2
   whno3(2,1)=30.0
   whno3(2,2)=45.0
   whno3(2,3)=50.0
! file3
   whno3(3,1)=30.0
   whno3(3,2)=40.0
   whno3(3,3)=45.0
   whno3(3,4)=50.0
! file4
   whno3(4,1)=30.0
   whno3(4,2)=40.0
   whno3(4,3)=45.0
   whno3(4,4)=50.0
! file5
! yes, the zero is correct
   whno3(5,1)=0.0
   whno3(5,2)=20.0
! file6
! yes, the zero is correct
   whno3(6,1)=0.0
   whno3(6,2)=10.0
   whno3(6,3)=20.0
   whno3(6,4)=30.0
   whno3(6,5)=40.0
   whno3(6,6)=45.0
   whno3(6,7)=50.0
! file7
! yes, the zero is correct
   whno3(7,1)=0.0
   whno3(7,2)=10.0
   whno3(7,3)=20.0
   whno3(7,4)=30.0
   whno3(7,5)=40.0
   whno3(7,6)=45.0
   whno3(7,7)=50.0

!          '123456789012345678901234567890123456789012345678901234567890'
  files(1)='biermann_hno3/hno3T213.biermann                             '
  files(2)='biermann_hno3/hno3T223.biermann                             '
  files(3)='biermann_hno3/hno3T233.biermann                             '
  files(4)='biermann_hno3/hno3T253.biermann                             '
  files(5)='biermann_hno3/hno3T263.biermann                             '
  files(6)='biermann_hno3/hno3T273.biermann                             '
  files(7)='biermann_hno3/hno3T293.biermann                             '

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The compound string
!       '1234567890123456'
  llset=' Biermann H2SO4 '

  do nf=1,mtempmax

! The input ascii file
  fil=files(nf)
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! Open input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,18
   read(idat,fmt=100) header
  end do
  100 format(a80)

! The number of lines to work with
!   oops, the ascii file reversed wavenumber and wavelength
    nlines=ndatr
    nc=nhno3(nf)
   do i=1,nlines
!   read(idat,*) wavecmr(i,nf),wavelr(i,nf),(rndatn(i,nf,j),j=1,nc)
!   read(idat,*) wavelr(i,nf),wavecmr(i,nf),(rndatn(i,nf,j),j=1,nc)
    read(idat,*) wcmr2(i),waver2(i),(rndatn(i,nf,j),j=1,nc)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

    nlines=ndati
   do i=1,nlines
!   read(idat,*) wavecmi(i,nf),waveli(i,nf),(ridatn(i,nf,j),j=1,nc)
    read(idat,*) wcmi2(i),wavei2(i),(ridatn(i,nf,j),j=1,nc)
   end do

  end do

  close (idat)

! ****
! Determine which data to look at
  
! Will specify the wghthno3 and temp pair
! First, will write out the possibilities

! The whno3 and temps values
  if (nopr .eq. 1) then
   write(iout,fmt=320) 
   320 format(/,2x,"rdbiermann_hno3: i,j,whno3(i,j),temps(i)")
   do i=1,mtempmax
   do j=1,nwt
    write(iout,fmt=330) i,j,whno3(i,j),temps(i)
    330 format(2x,2(1x,i4),2x,2(1x,f10.4))
   end do
   end do
  end if

! **
! Write out to the screen
   write(0,fmt=360) 
   360 format(/,2x,"rdbiermann_hno3: i,temps(1),whno3(i,j)")
   do i=1,mtempmax
   do j=1,nwt
    ivec1(j)=int(whno3(i,j))
    ivec2(j)=int(temps(i))
   end do
    write(0,fmt=365) i,ivec2(1),(ivec1(j),j=1,7)
    365 format(2x,1(1x,i3),1(1x,i4),2x,7(1x,i4))
   end do

! Specify the temp and wghthno3 values
  write(0,fmt=165)
  165 format(2x,"Specify temp value (e.g. 215) ")
  read(5,*) temp

  write(0,fmt=160)
  160 format(2x,"Specify wghthno3 value (e.g. 80) ")
  read(5,*) wghthno3

  write(0,fmt=170) wghthno3,temp
  170 format(2x," wghthno3,temp ",2(1x,f10.4))

    diffmin=1.0e3
    ival=-99
    jval=-99
   do i=1,nwt
   do j=1,mtempmax
    diff1=whno3(j,i)-wghthno3
    diff2=temps(j)-temp
    a1=sqrt((diff1*diff1)+(diff2*diff2))
    if (a1 .lt. diffmin) then 
     ival=i
     jval=j
     diffmin=a1
    end if
   end do
   end do

  if ((ival .lt. 0) .or. (jval .lt. 0)) then
   write(iout,fmt=350) ival,jval
   350 format(/,2x,"rdbiermann_hno3: ival,jval ",2(1x,i4)," will stop")
   stop
  end if

  if (nopr .eq. 1) then
   write(iout,fmt=170) wghthno3,temp
   write(iout,fmt=410) ival,jval,whno3(jval,ival),temps(jval)
   410 format(/,2x,"rdbiermann_hno3:ival,jval,whno3,temps, ",/,&
   2x,2(1x,i4),2(1x,f10.4))
  end if

! *****
! Put values into the output arrays

! The real indices
! real :: rndatn(ndatr,mtempmax,nwt)
   nlines=ndatr
  do i=1,nlines
   wcmr(i)=wcmr2(i)
   wavelengthr(i)=waver2(i)
!  write(0,fmt=7000) i,wcmr2(i),waver2(i),rndatn(i)
   7000 format(2x,i4,2x,3(1x,f10.4))
   a1=rndatn(i,jval,ival)
   if (a1 .le. 0.0) then 
    a1=0.0
   endif
   rndat(i)=a1
  end do

! The imaginary indices
   nlines=ndati
  do i=1,nlines
   wcmi(i)=wcmi2(i)
   wavelengthi(i)=wavei2(i)
   a2=ridatn(i,jval,ival)
   if (a2 .le. 0.0) then 
    a2=0.0
   endif
   ridat(i)=a2
  end do

! *****
  if (nopr .eq. 1) then

    write(iout,fmt=800) temp,wghthno3
    800 format(/,2x,"rdbiermann_hno3: temp,wghthno3 ",/,2x,2(1x,f10.4),/,&
    2x,"rdbiermann_hno3: i,wcmr,wavelengthr,rndat")
   do i=1,nlinesr
    write(iout,fmt=850) i,wcmr(i),wavelengthr(i),rndat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do

    write(iout,fmt=870) temp,wghthno3
    870 format(/,2x,"rdbiermann_hno3: temp,wghthno3 ",/,2x,2(1x,f10.4),/,&
    2x,"rdbiermann_hno3: i,wcmi,wavelengthi,ridat")
   do i=1,nlinesi
    write(iout,fmt=880) i,wcmi(i),wavelengthi(i),ridat(i)
    880 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
