  subroutine rdzarzana_soa(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=1,ncomp=9
  integer :: noprf,mset,itemp,i1,i2
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=40) :: files(ncomp)
  character (len=16) :: llset,file2(ncomp)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/zarzana_soa.dat                                '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456'
  file2(1)='Z glyoxal-glycin'
  file2(2)='Z glyoxal-methyl'
  file2(3)='Z methylglyoxal '
  file2(4)='Z glyoxal-methyl'
  file2(5)='D pollute HULIS '
  file2(6)='D smoke HULIS   '
  file2(7)='D puszta HULIS  '
  file2(8)='H HULIS-day     '
  file2(9)='H HULIS-night   '
!          '1234567890123456789012345678901234567890'
  files(1)='Zarzana   glyoxal-glycine               '
  files(2)='Zarzana   glyoxal-methylamine           '
  files(3)='Zarzana   methylglyoxal-glycine         '
  files(4)='Zarzana   glyoxal-methylamine           '
  files(5)='Dinar (2008) pollution HULIS            '
  files(6)='Dinar (2008) smoke HULIS                '
  files(7)='Dinar (2008) K-puszta HULIS             '
  files(8)='Hoffer (2006) HULIS-day                 '
  files(9)='Hoffer (2006) HULIS-night               '

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific case")
  write(0,fmt=145)
  145 format(2x," i, mset ")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a40)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-9) ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=file2(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! *****
! Specify how many lines to work with
  nlines=ndat

  write(0,fmt=700) nlines
  write(iout,fmt=700) nlines
  700 format(/,2x,"nlines ",i4)

! Data: Real and imaginary indices at 532 nm of proxies of secondary
! organic aerosol, and other determinations of HULIS indices

! Reference: Kyle J. Zarzana, David O. DeHaan, Miriam A. Freedman,
! Christa A. Hasenkopf, and Margaret A. Tolbert.
! Optical Propertiers of the Products of alpha-Dicarbonyl and Amine
! Reactions in Simulated Cloud Droplets, Env Sci Tech,46,4845-4851,2012

! Contact: Kyle Zarzana (kyle.zarzana@colorado.edu)

! Note: See Table 1 of the paper which also reports values from others.
! HULIS are HUmic LIke Substances
! case index    case
!  0            Zarzana   glyoxal-glycine
!  1            Zarzana   glyoxal-methylamine
!  2            Zarzana   methylglyoxal-glycine
!  3            Zarzana   glyoxal-methylamine
!  4            Dinar (2008) pollution HULIS
!  5            Dinar (2008) smoke HULIS
!  6            Dinar (2008) K-puszta HULIS
!  7            Hoffer (2006) HULIS-day
!  8            Hoffer (2006) HULIS-night
!
! Format: 1 line 2x,2(1x,f9.3),2(1x,f10.4)
!
! 0            Zarzana   glyoxal-glycine
!      cm-1    microns     real imaginary
!   18796.992     0.532     1.6400     0.0440

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,25
   read(idat,fmt=100) header
  end do
  100 format(a80)

  do j=1,ncomp
   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),rnval(i,j),rival(i,j)
   end do
  end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   rndat(i)=rnval(i,mset)
   ridat(i)=rival(i,mset)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdzarzana_soa: work with mset, files(mset)",/,&
    2x,i3,2x,a40)
    write(iout,fmt=840)
    840 format(2x,"rdzarzana_soa: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
