  subroutine rdmyhre_h2so4(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
! Notice that the exact number of elements in rnval,rival works
  integer,parameter :: ndat=4733,mtempmax=5,mcases=7
  integer :: i,mn,nc
  integer :: ival,jval
  real :: a1,a2
  real :: wghth2so4
  real :: vec1(mtempmax),vec2(mtempmax)
  real :: diff1,diff2
! Note that the ndat,mtemp is opposite to the ncdump dump
  real :: numlinesr(mcases),numlinesi(mcases)
  real :: temps(mcases,mtempmax)
  real :: ntemps(mcases)
  real :: wh2so4(mcases,mtempmax)
  real :: wcmr(ndat,mcases),wavelengthr(ndat,mcases)
  real :: wcmi(ndat,mcases),wavelengthi(ndat,mcases)
  real :: rn(ndat,mcases,mtempmax)
  real :: ri(ndat,mcases,mtempmax)
  character(len=60) :: fil
  character(len=60) :: files(mcases)
  character (len=16) :: llset

! ***
   data ntemps/5,5,5,5,5,5,2/
   do i=1,mcases
    numlinesr(i)=4733.0
    numlinesi(i)=4733.0
   end do

! set1
   temps(1,1)=298.0
   temps(1,2)=273.0
   temps(1,3)=267.0
   temps(1,4)=298.0
   temps(1,5)=273.0
! set2
   temps(2,1)=233.0
   temps(1,2)=213.0
   temps(2,3)=203.0
   temps(2,4)=298.0
   temps(2,5)=253.0
! set3
   temps(3,1)=245.0
   temps(3,2)=233.0
   temps(3,3)=223.0
   temps(3,4)=213.0
   temps(3,5)=203.0
! set4
   temps(4,1)=298.0
   temps(4,2)=263.0
   temps(4,3)=243.0
   temps(4,4)=223.0
   temps(4,5)=298.0
! set5
   temps(5,1)=243.0
   temps(5,2)=233.0
   temps(5,3)=298.0
   temps(5,4)=273.0
   temps(5,5)=234.0
! set6
   temps(6,1)=213.0
   temps(6,2)=298.0
   temps(6,3)=277.0
   temps(6,4)=257.0
   temps(6,5)=243.0
! set7
   temps(7,1)=223.0
   temps(7,2)=213.0

! set1
   wh2so4(1,1)=81.0
   wh2so4(1,2)=81.0
   wh2so4(1,3)=81.0
   wh2so4(1,4)=76.0
   wh2so4(1,5)=76.0
! set2
   wh2so4(2,1)=76.0
   wh2so4(1,2)=76.0
   wh2so4(2,3)=76.0
   wh2so4(2,4)=72.0
   wh2so4(2,5)=72.0
! set3
   wh2so4(3,1)=72.0
   wh2so4(3,2)=72.0
   wh2so4(3,3)=72.0
   wh2so4(3,4)=72.0
   wh2so4(3,5)=72.0
! set4
   wh2so4(4,1)=65.0
   wh2so4(4,2)=65.0
   wh2so4(4,3)=65.0
   wh2so4(4,4)=65.0
   wh2so4(4,5)=58.0
! set5
   wh2so4(5,1)=58.0
   wh2so4(5,2)=58.0
   wh2so4(5,3)=48.0
   wh2so4(5,4)=48.0
   wh2so4(5,5)=48.0
! set6
   wh2so4(6,1)=48.0
   wh2so4(6,2)=38.0
   wh2so4(6,3)=38.0
   wh2so4(6,4)=38.0
   wh2so4(6,5)=38.0
! set7
   wh2so4(7,1)=38.0
   wh2so4(7,2)=38.0

! ***
! Will read in all of the data

! ***
! Read in the data from the ascii file
   lset=lstrn

! The compound string
!       '1234567890123456'
  llset=' Myhre H2SO4    '

! ***
!          '123456789012345678901234567890123456789012345678901234567890'
  files(1)='myhre_h2so4/myhreh2so4set1.dat                              '
  files(2)='myhre_h2so4/myhreh2so4set2.dat                              '
  files(3)='myhre_h2so4/myhreh2so4set3.dat                              '
  files(4)='myhre_h2so4/myhreh2so4set4.dat                              '
  files(5)='myhre_h2so4/myhreh2so4set5.dat                              '
  files(6)='myhre_h2so4/myhreh2so4set6.dat                              '
  files(7)='myhre_h2so4/myhreh2so4set7.dat                              '

  do nf=1,mcases

! The input ascii file
  fil=files(nf)
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

!  Data: Real and imaginary indices of H2SO4/H2O droplets
!  0.81, 0.81, 0.81, 0.76, 0.76 Weight percent H2SO4
!  298,  273,  267,  298,  273 K

! Reference: Myhre, C. E. Lund, D. H. Christensen, F. M. Nicolaisen,
! and C. J. Nielsen, Spectroscopic Study of Aqueous H2SO4 at Different
! Temperatures and Compositions: Variations in Dissociation and
! Optical Properties, J. Phys. Chem., volume 107, pgs. 1979-1991, 2005.

! Email contact person: C. E. Lund Myhre (e.c.lund@iakh.uio.no.)

! Format: 4733 real indices (2x,f7.2,2x,f10.4,5(2x,f7.5))
!         4733 imaginary indices (2x,f7.2,2x,f10.4,5(1x,e11.4))

! cm-1        microns   rnw81t298, rnw81t273, rnw81t267, rnw76t298, rnw76t273
! 7498.52      1.3336  1.41749  1.41747  1.42001  1.41318  1.40669
! 7497.02      1.3339  1.41766  1.41764  1.42017  1.41319  1.40672
! 7495.52      1.3341  1.41791  1.41789  1.42042  1.41321  1.40674

! Open input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,15
   read(idat,fmt=100) header
  end do
  100 format(a80)

! The number of lines to work with
   nlines=numlinesr(nf)
   nc=ntemps(nf)
   do i=1,nlines
    read(idat,*) wcmr(i,nf),wavelengthr(i,nf),(rn(i,nf,j),j=1,nc)
   end do

  do i=1,2
   read(idat,fmt=100) header
  end do

   nlines=numlinesi(nf)
   do i=1,nlines
    read(idat,*) wcmi(i,nf),wavelengthi(i,nf),(ri(i,nf,j),j=1,nc)
   end do

  close (idat)

  end do
! loop over file

! *****
! Find the indices for the interpolation
  
! Will specify the wghth2so4 and temp pair
! First, will write out the possibilities

! The wh2so4 and temps values
  if (nopr .eq. 1) then
   write(iout,fmt=320) 
   320 format(/,2x,"rdmyhre_h2so4: i,j,wh2so4(i,j),temps(i,j)")
   do i=1,mcases
   do j=1,mtempmax
    write(iout,fmt=330) i,j,wh2so4(i,j),temps(i,j)
    330 format(2x,2(1x,i4),2x,2(1x,f10.4))
   end do
   end do
  end if

! **
! Write out to the screen
   write(0,fmt=360) 
   360 format(/,2x,"rdmyhre_h2so4: i,j,wh2so4(i,j),temps(i,j)")
   do i=1,mcases
   do j=1,mtempmax
    vec1(j)=wh2so4(i,j)
    vec2(j)=temps(i,j)
   end do
    write(0,fmt=365) i,(vec1(j),j=1,5)
    365 format(2x,1(1x,i3),5(1x,f10.4))
    write(0,fmt=367) (vec2(j),j=1,5)
    367 format(2x,4x,5(1x,f10.4))
   end do

! Specify the temp and wghth2so4 values
  write(0,fmt=160)
  160 format(2x,"Specify wghth2so4 value (e.g. 72.0) ")
  read(5,*) wghth2so4

  write(0,fmt=165)
  165 format(2x,"Specify temp value (e.g. 233.0) ")
  read(5,*) temp

  write(0,fmt=170) wghth2so4,temp
  170 format(2x," wghth2so4,temp ",2(1x,f10.4))

    diffmin=1.0e3
    ival=-99
    jval=-99
   do i=1,mcases
   do j=1,mtempmax
    diff1=wh2so4(i,j)-wghth2so4
    diff2=temps(i,j)-temp
    a1=sqrt((diff1*diff1)+(diff2*diff2))
    if (a1 .lt. diffmin) then 
     ival=i
     jval=j
     diffmin=a1
    end if
   end do
   end do

  if ((ival .lt. 0) .or. (jval .lt. 0)) then
   write(iout,fmt=350) ival,jval
   350 format(/,2x,"rdmyhre_h2so4: ival,jval ",2(1x,i4)," will stop")
   stop
  end if

  if (nopr .eq. 1) then
   write(iout,fmt=410) ival,jval,wh2so4(ival,jval),temps(ival,jval)
   410 format(/,2x,"rdmyhre_h2so4:ival,jval,wh2so4,temps, ",/,&
   2x,2(1x,i4),2(1x,f10.4))
  end if

! *****
! Put values into the output arrays
! rn(ndat,mcases,mtempmax)
! ri(ndat,mcases,mtempmax)
   nlines=numlinesr(1)
  do i=1,nlines
   wcm(i)=wcmr(i,ival)
   wavelength(i)=wavelengthr(i,ival)
   a1=rn(i,ival,jval)
   a2=ri(i,ival,jval)
   if (a1 .le. 0.0) then 
    a1=0.0
   endif
   if (a2 .le. 0.0) then 
    a2=0.0
   endif
   rndat(i)=a1
   ridat(i)=a2
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) temp,wghth2so4
    800 format(/,2x,"rdmyhre_h2so4: temp,wghth2so4 ",/,2x,2(1x,f10.4),/,&
    2x,"rdmyhre_h2so4: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
