  subroutine calcsized(nopr,iout,&
  r1,r2,&
  den1,rad1,sig1,&
  den2,rad2,sig2,&
  ndist,radr,sized,&
  outdir,iwrsize,lset)

! *************************
! See rdwork.f90
  integer :: noprwork,noprtest,noprlist,noprind,noprwave,noprsize,noprext
  integer :: itest,iset,iwrind,iwrsize,iwrext
  integer :: iwave
  real :: w1,w2,dw
  real :: r1,r2
  real :: den1,rad1,sig1
  real :: den2,rad2,sig2

! See rdindices.f90
  character (len=100) :: lset

! Used here
  integer,parameter :: ndist2=200
  integer :: i,ifirst,iskip,ilast,mn
  real :: radr2(ndist2),sized2(ndist2)
 
! Output
  real :: radr(ndist2),sized(ndist2)

! *************************
  r1log=alog(r1)
  r2log=alog(r2)

  pi=3.14159265
  const=sqrt(2.0*pi)

   s1=alog(sig1)
  if (sig2 .gt. 1.0) then 
   s2=alog(sig2)
  end if
  if (sig2 .lt. 1.0) then
   den2=0.0
  end if

  dlog=(r2log-r1log)/(1.00*ndist2)

! Calculate the size distribution
  do i=1,ndist2 

   term1=0.0
   term2=0.0

   rlog=r1log+((i-1)*dlog)
   radr2(i)=exp(rlog)

   if (den1 .ge. 1.0e-6) then 
    alpha1=(alog(radr2(i)/rad1))/s1
    a2=(alpha1*alpha1)/2.0
    term1=den1*(1.0/(radr2(i)*s1*const))*exp(-a2)
   end if
   if (den2 .ge. 1.0e-6) then
    alpha2=(alog(radr2(i)/rad2))/s2
    a4=(alpha2*alpha2)/2.0
    term2=den2*(1.0/(radr2(i)*s2*const))*exp(-a4)
   end if

   sum=term1+term2
   sized2(i)=sum

  end do

! *************************
! Just use values that are greater than 1.0e-12

! **
    ifirst=-99
   do i=1,ndist2 
    if (sized2(i) .ge. 1.0e-12) then 
     ifirst=i
     go to 100
    end if
   end do
   100 mn=0

! **
    i1=ndist2
    i2=1
    iskip=-1
    ilast=-99
   do i=i1,i2,iskip
    if (sized2(i) .ge. 1.0e-12) then 
     ilast=i
     go to 110
    end if
   end do
   110 mn=0

! **
! Redefine the size distribution
    iok=0
   if ((ifirst .ge. 1) .and. (ilast .ge. 1)) then
     iok=1
    ndist=ilast-ifirst+1
     j=0
    do i=ifirst,ilast
     j=j+1
     radr(j)=radr2(i)
     sized(j)=sized2(i)
    end do
   end if

! *************************
  if (nopr .eq. 1) then 
   write(iout,fmt=200) r1,r2,ndist,den1,rad1,sig1,den2,rad2,sig2
   200 format(/,&
   2x,"calcsized: the size distribution is defined for the ",/,&
   2x,"calcsized: r1 to r2 range in microns",/,&
   2x,"calcsized: r1,r2 ",2(1x,f10.4),/,&
   2x,"calcsized: there are ndist size bins ",i4,/,&
   2x,"calcsized: den1,rad1,sig1 ",/,2x,1p,3(1x,e10.3),/,&
   2x,"calcsized: den2,rad2,sig2 ",/,2x,3(1x,e10.3),/,&
   2x,"calcsized: radr is in microns ",/,&
   2x,"calcsized:  sized = number per cm3 per micron radius increment ",/,&
   2x,"calcsized: i,radr(i),sized(i) ")
   do i=1,ndist
    write(iout,fmt=210) i,radr(i),sized(i)
    210 format(1(1x,i4),1p,2(1x,e10.3))
   end do
  end if

! *************************
  if (iwrsize .eq. 1) then
   call wrsize(nopr,iout,outdir,&
   r1,r2,&
   den1,rad1,sig1,&
   den2,rad2,sig2,&
   ndist,radr,sized,&
   lset)
  end if

! *************************
  return
  end
