   pro wrsize,nopr,iout,outdir,$
   r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   ndist,radr,sized,$
   lset

; *************************
; Header
  hset=strarr(1)
  hset=strmid(lset,0,60)

; *************************
  filnm=strarr(1)
  filnm=strcompress(outdir+'size.ascii')

   idat=30
  openw,idat,filnm

; Write out to the output ascii file
   printf,idat,'  ',hset
   printf,idat,'  Radius is in microns'
   printf,idat,'  Sized is the size distribution'
   printf,idat,'    number / cm3 per micron increment in radius'
   printf,idat,'  Number of size distribution bins'
   printf,idat,'  ',ndist
   printf,idat,'  i,radius,sized,'
   for i=0,ndist-1 do begin
    printf,idat,format='(1(1x,i4,","),2(1x,e11.4,","))',$
     i,radr(i),sized(i)
   endfor

   print,'  wrsize: wrote to ',filnm
   close,idat

; *************************
; Write out to the output netCDF file
  wrfile=strarr(1)
  wrfile=strcompress(outdir+'size.nc')

; **
   ntext=8
  text=strarr(ntext)
;         '1234567890123456789012345678901234567890'
  text(0)=' Radius in microns                      '
  text(1)=' Size Distribution in number / cm3 per  '
  text(2)=' increment in radii                     '
  text(3)=' log-normal size distribution Den #/cm3 ' 
  text(4)=' mode Rad (microns), width Sig (none)   '
  text(5)=' Note that alog(sig) is used in formula '
  text(6)=' of the log normal size distribution    '
  text(7)=' and that there are two modes           '

; **
; Open the netCDF file
; The file is in define mode
     id=NCDF_CREATE(wrfile,/CLOBBER)

; **
; Define variable ids
     idndist=NCDF_DIMDEF(id,'ndist',ndist)
     idntext=NCDF_DIMDEF(id,'ntext',ntext)

; For character strings
      n40=40
     idn40=NCDF_DIMDEF(id,'n40',n40)

; **
; Define variables
     id1=NCDF_VARDEF(id,'ndist',/SHORT)
     id2=NCDF_VARDEF(id,'ntext',/SHORT)
     id3=NCDF_VARDEF(id,'n40',/SHORT)
     id4=NCDF_VARDEF(id,'r1',/FLOAT)
     id5=NCDF_VARDEF(id,'r2',/FLOAT)
     id6=NCDF_VARDEF(id,'den1',/FLOAT)
     id7=NCDF_VARDEF(id,'rad1',/FLOAT)
     id8=NCDF_VARDEF(id,'sig1',/FLOAT)
     id9=NCDF_VARDEF(id,'den2',/FLOAT)
     id10=NCDF_VARDEF(id,'rad2',/FLOAT)
     id11=NCDF_VARDEF(id,'sig2',/FLOAT)

      dimx=[idndist]
     id20=NCDF_VARDEF(id,'radius',dimx)
     id21=NCDF_VARDEF(id,'sized',dimx)

; **
; The text associated with the file
     id22=NCDF_VARDEF(id,'text',[idn40,idntext],/CHAR)

; **
; Put the file in data mode (so you can write to it)
     NCDF_CONTROL,id,/ENDEF

; **
; Specify the values
     NCDF_VARPUT,id,id1,ndist
     NCDF_VARPUT,id,id2,ntext
     NCDF_VARPUT,id,id3,n40
     NCDF_VARPUT,id,id4,r1
     NCDF_VARPUT,id,id5,r2
     NCDF_VARPUT,id,id6,den1
     NCDF_VARPUT,id,id7,rad1
     NCDF_VARPUT,id,id8,sig1
     NCDF_VARPUT,id,id9,den2
     NCDF_VARPUT,id,id10,rad2
     NCDF_VARPUT,id,id11,sig2

      countx=[ndist]
     NCDF_VARPUT,id,id20,radr,COUNT=countx
     NCDF_VARPUT,id,id21,sized,COUNT=countx

; Write out the character strings
     counts=[n40,ntext]
     NCDF_VARPUT,id,id22,text,COUNT=counts

; **
; Close the data set
     NCDF_CLOSE,id

; **
    print,'  wrsize: wrote to ',wrfile

    printf,iout,'  '
    printf,iout,'  wrsize: wrote to netCDF file '
    printf,iout,'  ',wrfile

; *************************
  return
  end
