    pro wrext,nopr,iout,outdir,iwave,$
    nwave,wave,bext,babs,bsca,asym,omega

; *************************
  filnm=strarr(1)
  filnm=strcompress(outdir+'ext.ascii')

   idat=30
  openw,idat,filnm

; Will write out both wavenumbers and wavelength
  wavecm=fltarr(nwave)
  wavelength=fltarr(nwave)

; Write out to the output ascii file
   printf,idat,'  wrext: bext,babs,bsca, are in 1/km units'
   printf,idat,'  wrext: asym,omega are unitless'
   printf,idat,'  wrext: nwave '
   printf,idat,'  ',nwave
   printf,idat,'  wrext: i,wavecm,wavelength,bext,babs,bsca,asym,omega'
   for i=0,nwave-1 do begin
    if (iwave eq 1) then begin
     a1=wave(i)
     a2=1.0e4/wave(i)
    endif
    if (iwave eq 2) then begin
     a1=1.0e4/wave(i)
     a2=wave(i)
    endif
     wavecm(i)=a1
     wavelength(i)=a2
    printf,idat,format='(1(1x,i3,","),2(1x,f10.4,","),5(1x,e10.3,","))',$
     i,a1,a2,bext(i),babs(i),bsca(i),asym(i),omega(i)
   endfor

   print,'  wrext: wrote to ',filnm
   close,idat

; *************************
; Write out to the output netCDF file
  wrfile=strarr(1)
  wrfile=strcompress(outdir+'ext.nc')

; **
   ntext=5
  text=strarr(ntext)
;         '1234567890123456789012345678901234567890'
  text(0)=' Extinction (km-1)                      '
  text(1)=' Absorption (km-1)                      '
  text(2)=' Scattering (km-1)                      '
  text(3)=' Asymmetry  Parameter                   '
  text(4)=' Single Scattering  Albedo              '

; **
; Open the netCDF file
; The file is in define mode
     id=NCDF_CREATE(wrfile,/CLOBBER)

; **
; Define variable ids
     idnwave=NCDF_DIMDEF(id,'nwave',nwave)
     idntext=NCDF_DIMDEF(id,'ntext',ntext)

; For character strings
      n40=40
     idn40=NCDF_DIMDEF(id,'n40',n40)

; **
; Define variables
     id1=NCDF_VARDEF(id,'nwave',/SHORT)
     id2=NCDF_VARDEF(id,'ntext',/SHORT)
     id3=NCDF_VARDEF(id,'n40',/SHORT)

      dimx=[idnwave]
     id9=NCDF_VARDEF(id,'wavecm',dimx)
     id10=NCDF_VARDEF(id,'wavelength',dimx)
     id11=NCDF_VARDEF(id,'bext',dimx)
     id12=NCDF_VARDEF(id,'babs',dimx)
     id13=NCDF_VARDEF(id,'bsca',dimx)
     id14=NCDF_VARDEF(id,'asym',dimx)
     id15=NCDF_VARDEF(id,'omega',dimx)

; **
; The text associated with the file
     id16=NCDF_VARDEF(id,'text',[idn40,idntext],/CHAR)

; **
; Put the file in data mode (so you can write to it)
     NCDF_CONTROL,id,/ENDEF

; **
; Specify the values
     NCDF_VARPUT,id,id1,nwave
     NCDF_VARPUT,id,id2,ntext
     NCDF_VARPUT,id,id3,n40

      countx=[nwave]
     NCDF_VARPUT,id,id9,wavecm,COUNT=countx
     NCDF_VARPUT,id,id10,wavelength,COUNT=countx
     NCDF_VARPUT,id,id11,bext,COUNT=countx
     NCDF_VARPUT,id,id12,babs,COUNT=countx
     NCDF_VARPUT,id,id13,bsca,COUNT=countx
     NCDF_VARPUT,id,id14,asym,COUNT=countx
     NCDF_VARPUT,id,id15,omega,COUNT=countx

; Write out the character strings
     counts=[n40,ntext]
     NCDF_VARPUT,id,id16,text,COUNT=counts

; **
; Close the data set
     NCDF_CLOSE,id

; **
    print,'  wrext: wrote to ',wrfile

    printf,iout,'  '
    printf,iout,'  wrext: wrote to netCDF file '
    printf,iout,'  ',wrfile

; *************************
  return
  end
