   pro simplemix,iout,m1,m2,f2,m3

;-----------------------------------------------------------
; routine uses a volume (or mass) averaging
; find the refractive index of a mixture of two substances.
;
; Input:
;   m1......complex refractive index of substance 1 (matrix)
;   m2......complex refractive index of substance 2 (inclusions)
;   f2......volume fraction of substance 2 (inclusions)
;
; Output:
;   m3....complex refractive index of mixture
;
;-----------------------------------------------------------
    a1=1.00-f2
    b1=0.0
   c1=complex(a1,b1)
    a2=f2
    b2=0.0
   c2=complex(a2,b2)

; The simple mixture
   m3 = (c1*m1) + (c2*m2)

; *****
   return
   end

