    pro samewave,nopr,iout,$
    nlines,wcm,wavelength,$
    nlinesr,wcmr,wavelengthr,rndat,$
    nlinesi,wcmi,wavelengthi,ridat

; *************************
; Put values into temporary rndat2 and ridat2 arrays
     rndat2=fltarr(nlinesr)
    for i=0,nlinesr-1 do begin
     rndat2(i)=rndat(i)
    endfor

     ridat2=fltarr(nlinesi)
    for i=0,nlinesi-1 do begin
     ridat2(i)=ridat(i)
    endfor

; *************************
; Note ranges to work with
     wavelminr=1.0e6
     wavelmaxr=-1.0e6
    for i=0,nlinesr-1 do begin
     if (wavelengthr(i) lt wavelminr) then begin
      wavelminr=wavelengthr(i)
     endif
     if (wavelengthr(i) gt wavelmaxr) then begin
      wavelmaxr=wavelengthr(i)
     endif
    endfor

     wavelmini=1.0e6
     wavelmaxi=-1.0e6
    for i=0,nlinesi-1 do begin
     if (wavelengthi(i) lt wavelmini) then begin
      wavelmini=wavelengthi(i)
     endif
     if (wavelengthi(i) gt wavelmaxi) then begin
      wavelmaxi=wavelengthi(i)
     endif
    endfor

  print,'  samewave: nlinesi,nlinesr ',nlinesi,nlinesr
  print,'  samewave: wavelmini,wavelminr  ',wavelmini,wavelminr 
  print,'  samewave: wavelmaxi,wavelmaxr  ',wavelmaxi,wavelmaxr 

; *************************
; Case where imaginary wavelength range is less than real range
; e.g. rdliu_soa_acp.pro
   if ((wavelmini le wavelminr) and (wavelmaxi le wavelmaxr)) then begin

       icalc=0
     print,'  samewave: icalc ',icalc

     for i=0,nlinesi-1 do begin
      if (wavelengthi(i) ge wavelengthr(0)) then begin
       istart=i
       goto,jump1
      endif
     endfor
     jump1: mn=0

; **
      nlines=nlinesi-istart

     wcm=fltarr(nlines)
     wavelength=fltarr(nlines)
     rndat=fltarr(nlines)
     ridat=fltarr(nlines)

;    help,ridat2
;    help,ridat
;    stop

; **
; The imaginary values are the primary ones to work with
      m=istart-1
     for i=0,nlines-1 do begin
       m=m+1
;      print,m
      ridat(i)=ridat2(m)
      wcm(i)=wcmi(m)
      wavelength(i)=wavelengthi(m)
     endfor

; **
; Find first match
       i=1
      diffmin=1.0e6
      istart=-99
     for ii=0,nlinesr-1 do begin
      diff=abs(wavelengthr(ii)-wavelength(i))
      if (diff lt diffmin) then begin
       istart=ii
       diffmin=diff
      endif
     endfor

; **
; Specify the rndat values
      idiff=5
      ii=istart
     for i=0,nlines-1 do begin

       j1=ii-idiff
       j2=ii+idiff
      if (j1 lt 0) then begin
       j1=0
      endif
      if (j2 ge nlinesr) then begin
       j2=nlinesr-1
      endif

       diffmin=1.0e6
       iuse=-99
      for j=j1,j2 do begin
       diff=abs(wavelengthr(j)-wavelength(i))
       if (diff lt diffmin) then begin
        iuse=j
        ii=j
        diffmin=diff
       endif
      endfor

       rndat(i)=0.0
      if ((iuse ge 0) and (iuse lt nlinesr)) then begin
       rndat(i)=rndat2(iuse)
      endif

      endfor
; loop over nlines

     goto,jump2

    endif

; *************************
    if (nlinesi lt nlinesr) then begin

; **
      nlines=nlinesi
     wcm=fltarr(nlines)
     wavelength=fltarr(nlines)
     rndat=fltarr(nlines)
     ridat=fltarr(nlines)

; **
; The imaginary values are the primary ones to work with
     for i=0,nlines-1 do begin
      ridat(i)=ridat2(i)
      wcm(i)=wcmi(i)
      wavelength(i)=wavelengthi(i)
     endfor

; **
; Find first match
      diffmin=1.0e6
      istart=-99
      i=0
     for ii=0,nlinesr-1 do begin
      diff=abs(wavelengthr(ii)-wavelength(i))
      if (diff lt diffmin) then begin
       istart=ii
       diffmin=diff
      endif
     endfor

; **
; Specify the rndat values
      idiff=5
      nlinesrm1=nlinesr-1
      ii=istart
     for i=0,nlines-1 do begin

       j1=ii-idiff
       j2=ii+idiff
      if (j1 lt 0) then begin
       j1=0
      endif
      if (j2 ge nlinesrm1) then begin
       j2=nlinessrm1
      endif
 
       diffmin=1.0e6
       iuse=-99
      for j=j1,j2 do begin
       diff=abs(wavelengthr(j)-wavelength(i))
       if (diff lt diffmin) then begin
        iuse=j
        ii=j
        diffmin=diff
       endif
      endfor

       rndat(i)=0.0
      if ((iuse ge 0) and (iuse lt nlinesi)) then begin
       rndat(i)=rndat2(iuse)
      endif 

      endfor

    endif

; *************************
    if (nlinesr lt nlinesi) then begin

; **
      nlines=nlinesr
     wcm=fltarr(nlines)
     wavelength=fltarr(nlines)
     rndat=fltarr(nlines)
     ridat=fltarr(nlines)

; **
; The real values are the primary ones to work with
     for i=0,nlines-1 do begin
      rndat(i)=rndat2(i)
      wcm(i)=wcmr(i)
      wavelength(i)=wavelengthr(i)
     endfor

; **
; Find first match
      diffmin=1.0e6
      i=0
     for ii=0,nlinesr-1 do begin
      diff=abs(wavelengthi(ii)-wavelength(i))
      if (diff lt diffmin) then begin
       istart=ii
       diffmin=diff
      endif
     endfor

; **
; Specify the rndat values
      idiff=5
      nlinesim1=nlinesi-1
      ii=istart
     for i=0,nlines-1 do begin

       j1=ii-idiff
       j2=ii+idiff
      if (j1 lt 0) then begin
       j1=0
      endif
      if (j2 ge nlinesim1) then begin
       j2=nlinessim1
      endif
 
       diffmin=1.0e6
       iuse=-99
      for j=j1,j2 do begin
       diff=abs(wavelengthi(j)-wavelength(i))
       if (diff lt diffmin) then begin
        iuse=j
        ii=j
        diffmin=diff
       endif
      endfor

       ridat(i)=0.0
      if ((iuse ge 0) and (iuse lt nlinesr)) then begin
       ridat(i)=ridat2(iuse)
      endif

      endfor

    endif

    jump2: mn=0

; *************************
; Write out the results
    printf,iout,'  '
    printf,iout,'  samewave: nlines,nlinesr,nlinesi'
    printf,iout,'  ',nlines,nlinesr,nlinesi
    printf,iout,'  samewave: i,wavelength(i),wcm(i),rndat(i),ridat(i)'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wavelength(i),wcm(i),rndat(i),ridat(i)
   endfor

; *************************
  return
  end
