   pro rdzarzana_soa_proxy,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; Note that there is only one wavelength (523 nm)

; ***
; The input netCDF file
  fil=strarr(1)
  fil='zarzana_soa.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnwave=ncdf_varid(nc_id,'nwave')
  idncases=ncdf_varid(nc_id,'ncases')
  idwcmobs=ncdf_varid(nc_id,'wcmobs')
  idwmicobs=ncdf_varid(nc_id,'wmicobs')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idrnerr=ncdf_varid(nc_id,'rnerr')
  idrierr=ncdf_varid(nc_id,'rierr')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idncases,ncases
  ncdf_varget,nc_id,idnwave,nwave
  ncdf_varget,nc_id,idwcmobs,wcmobs
  ncdf_varget,nc_id,idwmicobs,wmicobs
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri
  ncdf_varget,nc_id,idrnerr,rnerr
  ncdf_varget,nc_id,idrierr,rierr

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
  for i=12,21 do begin  
   print,text(i)
  endfor

; Specify the set to work with
  print,' specify icase  0 to 8 '
  read,icase

; *****
; For the graphs (oops, but there is only one wavelength)
  text2=strarr(9)
  str2=strarr(1)
   iadd=13
   nstart=13
   npos=32
  for i=0,8 do begin
   ii=i+iadd
   str2=strmid(text(ii),nstart,npos)
   text2(i)=str2
   print,text2(i)
  endfor

; *****
; Note that you only read in the data for which the real and imaginary
; parts are both specified
    nlines=nwave
   rndat=fltarr(nlines)
   ridat=fltarr(nlines)
   wcm=fltarr(nlines)
   wavelength=fltarr(nlines)

; **
; Specify the output values
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,icase)
    ridat(i)=ri(i,icase)
    wcm(i)=wcmobs(i)
    wavelength(i)=wmicobs(i)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+text2(icase))

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdzarzana_soa_proxy: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdzarzana_soa_proxy: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


