   pro rdsinyuk,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; For graphs
   lset=lstrn

; ***
; The input netCDF file
  fil=strarr(1)
  fil='sinyuk_saharan_dust.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnwave=ncdf_varid(nc_id,'nwave')
  idwcmobs=ncdf_varid(nc_id,'wcmobs')
  idwmicobs=ncdf_varid(nc_id,'wmicobs')
  idsinyuki=ncdf_varid(nc_id,'rsinyuki')
  idpattersoni=ncdf_varid(nc_id,'rpattersoni')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

;       short nwave ;
;       short ntext ;
;       short n70 ;
;       float wcmobs(nwave) ;
;       float wmicobs(nwave) ;
;       float rsinyuki(nwave) ;
;       float rpattersoni(nwave) ;

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnwave,nwave
  ncdf_varget,nc_id,idwcmobs,wcmobs
  ncdf_varget,nc_id,idwmicobs,wmicobs
  ncdf_varget,nc_id,idsinyuki,rsinyuki
  ncdf_varget,nc_id,idpattersoni,rpattersoni

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  rdsinyuk: real indices not present in data file, will set to 0'
  print,'  '
  print,'  rdsinyuk: specify to read in sinyuk (iset=1) or patterson (iset=2)'

  print,'  specify iset '
  read,iset

   nlines=nwave
  wcm=fltarr(nlines)
  wavelength=fltarr(nlines)
  rndat=fltarr(nlines)
  ridat=fltarr(nlines)
  for i=0,nlines-1 do begin
   wcm(i)=wcmobs(i)
   wavelength(i)=wmicobs(i)
   rndat(i)=0.0
   if (iset eq 1) then begin
    ridat(i)=rsinyuki(i)
    lset=strcompress(lstrn+' Sinyuk')
   endif
   if (iset eq 2) then begin
    ridat(i)=rpattersoni(i)
    lset=strcompress(lstrn+' Patterson')
   endif
  endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdsinyuki: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdsinyuki: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


