   pro rdmyhre_h2so4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='myhre_h2so4.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnumlinesr=ncdf_varid(nc_id,'numlinesr')
  idnumlinesi=ncdf_varid(nc_id,'numlinesi')
  idncases=ncdf_varid(nc_id,'ncases')
  idntempmax=ncdf_varid(nc_id,'ntempmax')
  idwh2so4=ncdf_varid(nc_id,'wh2so4')
  idtemps=ncdf_varid(nc_id,'temps')
  idntemps=ncdf_varid(nc_id,'ntemps')
  idwcmr=ncdf_varid(nc_id,'wcmr')
  idwavelengthr=ncdf_varid(nc_id,'wavelengthr')
  idrn=ncdf_varid(nc_id,'rn')
  idwcmi=ncdf_varid(nc_id,'wcmi')
  idwavelengthi=ncdf_varid(nc_id,'wavelengthi')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnumlinesr,numlinesr
  ncdf_varget,nc_id,idnumlinesi,numlinesi
  ncdf_varget,nc_id,idncases,ncases
  ncdf_varget,nc_id,idwh2so4,wh2so4
  ncdf_varget,nc_id,idntemps,ntemps
  ncdf_varget,nc_id,idtemps,temps
  ncdf_varget,nc_id,idwcmr,wcmr
  ncdf_varget,nc_id,idwavelengthr,wavelengthr
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idwcmi,wcmi
  ncdf_varget,nc_id,idwavelengthi,wavelengthi
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  myhre h2so4'
  print,'  ncases ',ncases
  print,'  ntemps ',ntemps
  print,'  The table to choose from'
   joffset=intarr(ncases)
   joffset=[0,1,0,1,0,1,0]
  for i=0,ncases-1 do begin
    nval=ntemps(i)
   vec1=fltarr(nval)
   vec2=fltarr(nval)
   for j=0,nval-1 do begin
    vec1(j)=temps(i,j)
    vec2(j)=wh2so4(i,j)
   endfor
;  print,'  '
   if (joffset(i) eq 0) then begin
    print,'  '
    print,'  ',vec1
    print,'  ',vec2
   endif
   if (joffset(i) eq 1) then begin
    print,'  '
    print,'   ',vec1
    print,'   ',vec2
   endif
  endfor

; *****
   print,'  '
   print,'  specify temperature and h2so4 pair (e.g. 298.0, 81.0)
   print,'  specify temp'
   read,temp
   print,'  specify h2so4'
   read,h2so4

    diffmin=1.0e6
    ival=-99
    jval=-99
    icase=-99
   for i=0,ncases-1 do begin
    nval=ntemps(i)
   for j=0,nval-1 do begin
    diff1=temp-temps(i,j)
    diff2=h2so4-wh2so4(i,j)
    diff=sqrt((diff1*diff1)+(diff2*diff2))
    if (diff lt diffmin) then begin  
     ival=i
     jval=j
     icase=i
     diffmin=diff
    endif
   endfor
   endfor

   if ((ival lt 0) or (jval lt 0)) then begin
    print,'  '
    print,'  rdmyhre_h2so4: icase ',icase
    print,'  rdmyhre_h2so4: ival,jval ',ival,jval
    print,'  rdmyhre_h2so4: ival or jval lt 0, will stop'
    stop
   endif

; **
   tempstr=strarr(1)
   tempstr=string(fix(temps(ival,jval)))
   h2so4str=strarr(1)
   h2so4str=string(fix(wh2so4(ival,jval)))

; **
     nlines=fix(numlinesr(icase))
    numr=fix(numlinesr(icase))
    numi=fix(numlinesr(icase))
    if (numr ne numi) then begin
     print,'  '
     print,'  rdmyhre: numr,numi ',numr,numi 
     print,'  rdmyhre: numr ne numi, will stop'
     stop
    endif

    rndat=fltarr(nlines)
    ridat=fltarr(nlines)
    wcm=fltarr(nlines)
    wavelength=fltarr(nlines)

    print,'  '
    print,'  rdmyhre: nlines,temp,temps(ival,jval) '
    print,'  ',nlines,temp,temps(ival,jval)
    print,'  rdmyhre: nlines,h2so4,wh2so4(ival,jval) '
    print,'  ',nlines,h2so4,wh2so4(ival,jval)

    printf,iout,'  '
    printf,iout,'  rdmyhre: nlines,temp,temps(ival,jval) '
    printf,iout,'  ',nlines,temp,temps(ival,jval)
    printf,iout,'  rdmyhre: nlines,h2so4,wh2so4(ival,jval) '
    printf,iout,'  ',nlines,h2so4,wh2so4(ival,jval)

; **
; Specify the output values
; Be careful on ival and jval !
; wcmr and wcmi are the same 
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,ival,jval)
    ridat(i)=ri(i,ival,jval)
    wcm(i)=wcmr(i,icase)
    wavelength(i)=wavelengthr(i,icase)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+tempstr+' K '+h2so4str+' %')

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdmyhre_h2so4: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdmyhre_h2so4: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


