  pro test4,nopr,$
  iout,indir,outdir,fout

; *****
; The output ps graphics file
  fileps=strcompress(outdir+'test4.ps')

  printf,iout,'  test4: ',fileps

; *****
; Open the output ps file
  set_plot, 'ps'
  device, /color, bits_per_pixel=8, file=fileps,$
   /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; *****
; First, test the bhcoat program (see pg 489 of Bohren and Huffman)

;        RFREL1 = REFCOR/REFMED
;        RFREL2 = REFMAN/REFMED
; where  REFCOR = complex refr.index of core)
;        REFMAN = complex refr.index of mantle)
;        REFMED = real refr.index of medium)
;        RCORE = radius of core
;        RMANT = radius of mantle
;        WAVEL = wavelength of light in ambient medium

   wavel=3.0
   rcore=0.171
   rmant=6.265
   refmed=1.000
   rrfrl1=complex(1.59,0.66)/refmed
   rrfrl2=complex(1.409,0.1747)/refmed

; Call bhcoat
   bhcoat,wavel,rcore,rmant,rrfrl1,rrfrl2,qext,qsca,qback

   printf,iout,'  '
   printf,iout,'  test4: rrfrl1 ',rrfrl1
   printf,iout,'  test4: rrfrl2 ',rrfrl2
   printf,iout,'  test4: qext,qsca,qback '
   printf,iout,'  ',qext,qsca,qback

; The answers (see pg 489 of Bohren and Huffman) 
   qqext=2.32803
   qqsca=1.14341
   qqback=0.0285099
   printf,iout,'  test4: Should see these values'
   printf,iout,'  ',qqext,qqsca,qqback

; *****
; Number of angles to specify for bhmie2.pro
   nang=20

; See Liou pg 138 for a graph of the values graphed here in this routine
; An Introduction to Atmospheric Radiation (1st edition)

; There ndist points in the spectrum
    ndist=20

; Look at 2 cases
     ncases=2
    xs=fltarr(ndist,ncases)

; Q for extinction
    qexts=fltarr(ndist,ncases)
; Q for scattering
    qscas=fltarr(ndist,ncases)
; Q for absorption
    qabs=fltarr(ndist,ncases)
; Q for backscatering
    qbacks=fltarr(ndist,ncases)

    xvec=fltarr(ndist)
    yvec=fltarr(ndist)
    yvec2=fltarr(ndist)
    yvec3=fltarr(ndist)
    isym=intarr(ndist)

; Note in this calculation that the refractive index is
; wavelength independent - this is only for this illustrative case !

; See this article which discusses scattering from a coated sphere.
; http://philiplaven.com/p8k1.html

; Real and imaginary indices of refraction
    refreal=fltarr(ncases)
    refim=fltarr(ncases)
    refreal=[1.5,1.5]
    refim=[0.0,0.00]

; For the coated sphere
   rcore=7.5
   rmant=2.5
   refmed=1.000
   rrfrl1=complex(1.5,0.0)/refmed
   rrfrl2=complex(1.333,0.0)/refmed

; For the titles of the graphs
   titles=strarr(ncases)
   titles=['Mie Sphere ','Coated Sphere ']

; ****
; Loop over cases
   for j=0,ncases-1 do begin

; The complex index of refraction
    refrel=complex(refreal(j),refim(j))

    printf,iout,'  '
    printf,iout,'  test1: *****'
    printf,iout,'  test1: titles(j) ',titles(j)
    printf,iout,'  test1: j,refrel ',j,refrel
    printf,iout,'  test1: qext is the MIE Q efficiency factor for extinction'
    printf,iout,'  test1: i,x,qext,qabs,qsca,qsca,qback'

    wavel=0.65
    w1=wavel-0.2
    w2=wavel+0.2
    dw=(w2-w1)/ndist
    twopi=2.00*3.14159265

; Loop over the points in the spectrum
   for i=0,ndist-1 do begin

; Calculate the Mie size parameter
   wave=w1+(i*dw)
   x=(twopi*rcore/wave)

; **
; Call the BHMIE routine of Bohren and Huffman "Absorption and Scattering
; of Light by Small Particles"
   if (j eq 0) then begin
    bhmie2,x,refrel,nang,s1,s2,qext,qsca,qback,gfac
   endif

; Call the Bohren and Hufmann routine for a coated sphere
   if (j eq 1) then begin
    bhcoat,wave,rcore,rmant,rrfrl1,rrfrl2,qext,qsca,qback
   endif

; **
; Store results
    xs(i,j)=x
    qexts(i,j)=qext
    qscas(i,j)=qsca
     a1=qext-qsca
    if (a1 lt 0.0) then begin
     a1=0.0
    endif
    qabs(i,j)=a1
    qbacks(i,j)=qback

    printf,iout,'  ',i,x,qext,a1,qsca,qback

    xvec(i)=x
    yvec(i)=qsca
    yvec2(i)=qext
    yvec3(i)=a1
    isym(i)=4

   endfor

; **
; Graph the data
   xmin=min(xvec)
   xmax=max(xvec)
   ymin=min(yvec2)
   ymax=max(yvec2)

   labelx='2 pi rad / wavelength'
   labely='Q extinction '

   ixlog=0
   iylog=0

   title=titles(J)

   ioplot=1

   graphxy,iout,xvec,yvec2,isym,ndist,labelx,labely,title,$
   xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

   endfor
; Loop over cases

; **
; Close the ps device
   device,/close

   print,'  output ps file is located at ',fileps

; *****
  return
  end
