  pro rduser_sizedist,nopr,iout,$
  dirusersizedist,$
  ndist,radr,sized,$
  outdir,igraphd,iwrsize,$
  lsetsize

; *************************
; Example of a size.ascii file
;   Tisdale H2SO4 75.0000 idl
; Radius is in microns
; Sized is the size distribution
;   number / cm3 per micron increment in radius
; Number of size distribution bins
;      200
; i,radius,sized,
;   0,  5.0000e-03,  1.7257e+03,
;   1,  5.1625e-03,  1.7662e+03,
;   2,  5.3303e-03,  1.8051e+03

  filnm=strarr(1)
  filnm=strcompress(dirusersizedist+'size.ascii')

  lsetsize='user specified size dist'

  print,filnm

   idat=40
  openr,idat,filnm

   header=strarr(1)
  for i=1,5 do begin
   readf,idat,header
  endfor

  readf,idat,ndist
  readf,idat,header

  radr=fltarr(ndist)
  sized=fltarr(ndist)

  for i=0,ndist-1 do begin
   readf,idat,j,a1,a2
   radr(i)=a1
   sized(i)=a2
  endfor

  close,idat

; *************************
  if (nopr eq 1) then begin
   printf,iout,'  '
   printf,iout,'  rduser_sizedist: lsetsize '
   printf,iout,'  ',lsetsize 
   printf,iout,'  rduser_sizedist: the size distribution is defined for the'
   printf,iout,'  rduser_sizedist: radr is in microns'
   printf,iout,'  rduser_sizedist: sized = number per cm3 per micron radius increment'
   printf,iout,'  rduser_sizedist: i,radr(i),sized(i)'
   for i=0,ndist-1 do begin
    printf,iout,'  ',i,radr(i),sized(i)
   endfor
  endif

; *************************
; Obtain r1 and r2
   r1=1.0e6
   r2=-1.0e6
   den1=0.0
   rad1=0.0
   sig1=0.0
   den2=0.0
   rad2=0.0
   sig2=0.0
  for i=0,ndist-1 do begin
   if (radr(i) lt r1) then begin
    r1=radr(i)
   endif
   if (radr(i) gt r2) then begin
    r2=radr(i)
   endif
  endfor

; *************************
  if (iwrsize eq 1) then begin
   wrsize,nopr,iout,outdir,$
   r1,r2,$
   den1,rad1,sig1,$
   den2,rad2,sig2,$
   ndist,radr,sized,$
   lsetsize
  endif

; *************************
; Graph the results
   if (igraphd eq 1) then begin

; The output ps graphics file
    fileps=strcompress(dirusersizedist+'gsized.ps')

; Open the output ps file
    set_plot, 'ps'
    device, /color, bits_per_pixel=8, file=fileps,$
     /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

      ngraphs=1
     titles=strarr(ngraphs)
     titles=['Size Distribution']

     xvec=fltarr(ndist)
     yvec=fltarr(ndist)
     isym=intarr(ndist)

; Loop over the graphs
    for ii=0,ngraphs-1 do begin

      for i=0,ndist-1 do begin
       xvec(i)=radr(i)
       yvec(i)=sized(i)
       isym(i)=4
      endfor

    labelx='Radius (microns)'
    labely=titles(ii)
    title=labely

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    ixlog=1
    iylog=1
    ioplot=1

    graphxy,iout,xvec,yvec,isym,ndist,labelx,labely,title,$
    xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

    endfor
; Loop over the graphs (one size distribution)

; Close the output ps graphics file
    print,' calcsized: wrote to ',fileps
    device,/close

   endif

; *************************
  return
  end
