   pro rduser_indices,nopr,iout,$
   diruserindices,$
   iwave,w1,w2,dw,$
   nwave,wave,rn,ri,$
   outdir,igraphi,iwrind,lset,lstrn,$
   ibothpos

; *************************
; Example of a indices.ascii ascii file
; wrindices: lset   Tisdale H2SO4 75.0000 idl
; wrindices: nlines
;      160
; wrindices: i,wavecm,wavelength,rn,ri
;   0,  2500.0000,     4.0000,  1.434e+00,  1.820e-01,
;   1,  2469.1357,     4.0500,  1.437e+00,  1.780e-01,
;   2,  2439.0244,     4.1000,  1.440e+00,  1.730e-01,

  filnm=strarr(1)
  filnm=strcompress(diruserindices+'indices.ascii')

  print,filnm

; ***
  lsetindices='user specified refractive indices'
  lset=lsetindices
  lstrn=lset

; ***
   idat=40
  openr,idat,filnm

   header=strarr(1)
  for i=1,2 do begin
   readf,idat,header
  endfor

  nwave2=intarr(1)

  readf,idat,nwave2
  readf,idat,header

  nwave=fix(nwave2(0))

  wavecm=fltarr(nwave)
  wavelength=fltarr(nwave)
  wave=fltarr(nwave)
  rn=fltarr(nwave)
  ri=fltarr(nwave)

  for i=0,nwave-1 do begin
   readf,idat,j,a1,a2,b1,b2
   wavecm(i)=a1
   wavelength(i)=a2
   wave(i)=a2
   rn(i)=b1
   ri(i)=b2
  endfor

  close,idat

; *************************
; Work with wavelength scale
   iwave=2
  w1=min(wavelength)
  w2=max(wavelength)
  dw=abs(wavelength(2)-wavelength(1))

; *************************
; Write out the interpolated indices to ascii and netCDF files
   if (iwrind eq 1) then begin
    wrindices,nopr,iout,outdir,$
    nwave,wave,rn,ri,iwave,$
    lsetindices
   endif

; *************************
; Graph the results
   if (igraphi eq 1) then begin

; The output ps graphics file
    fileps=strcompress(diruserindices+'gindex.ps')

; Open the output ps file
    set_plot, 'ps'
    device, /color, bits_per_pixel=8, file=fileps,$
     /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

      ngraphs=2
     titles=strarr(ngraphs)
     titles=['Real Index ','Imaginary Index']

      arrays=fltarr(nwave,ngraphs)
     for i=0,nwave-1 do begin
      arrays(i,0)=rn(i)
      arrays(i,1)=ri(i)
     endfor

     xvec=fltarr(nwave)
     yvec=fltarr(nwave)
     isym=intarr(nwave)

; Loop over the graphs
    for ii=0,ngraphs-1 do begin

      for i=0,nwave-1 do begin
       xvec(i)=wave(i)
       yvec(i)=arrays(i,ii)
       isym(i)=4
      endfor

    if (iwave eq 1) then begin
     labelx='Wavenumber (cm-1)'
    endif
    if (iwave eq 2) then begin
     labelx='Wavelength (microns)'
    endif
    labely=titles(ii)
    title=lsetindices

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    ixlog=0
    iylog=0
    ioplot=1

    graphxy,iout,xvec,yvec,isym,nwave,labelx,labely,title,$
    xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

    endfor
; Loop over the graphs

; Close the output ps graphics file
    print,' rduser_indices: wrote to ',fileps
    device,/close

   endif

; *************************
  return
  end
