   pro rdhesoa,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rndat,ridat,rnerr,rierr

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
; fil=strarr(1)
; fil=filnetcdf
; filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnfiles=ncdf_varid(nc_id,'nfiles')
  idnwave=ncdf_varid(nc_id,'nwave')

; idnweights=ncdf_varid(nc_id,'nweights')
; idwhno3=ncdf_varid(nc_id,'whno3')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

  idtext=ncdf_varid(nc_id,'text')
  idsoastrs=ncdf_varid(nc_id,'soastrs')

  idn70=ncdf_varid(nc_id,'n70')
  idn10=ncdf_varid(nc_id,'n10')
  idn6=ncdf_varid(nc_id,'n6')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn10,n10
  ncdf_varget,nc_id,idn6,n6
  ncdf_varget,nc_id,idnfiles,nfiles
  ncdf_varget,nc_id,idnwave,nwave

  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

  text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; soastrs=strarr(n70)
; ncdf_varget,nc_id,idsoastrs,soastrs
; soastrs=string(soastrs)

    soastrs=' β-pine (0) β-car (1)  α-hum (2)  isoprene (3)  δ3-car (4) α-ced (5)  '
    soastrs2=strarr(n6)
    soastrs2=['β-pine ','β-car ','α-hum  ','isoprene ','δ3-car ','α-ced']
;   soastrs2=['B-pine ','B-car ','A-hum  ','isoprene ','del3-car ','A-ced']

; ****
; Close the data set
  ncdf_close,nc_id

; ****
   ihelp=0
  if (ihelp eq 1) then begin
   help,rn
   help,ri
   help,wcm
   help,wavelength
   help,nwave
   help,ntext
   help,text
   help,soastrs
   help,soastrs2
   stop
; RN              FLOAT     = Array[153, 6]
; RI              FLOAT     = Array[153, 6]
; WCM             FLOAT     = Array[153]
; WAVELENGTH      FLOAT     = Array[153]
; NWAVE           INT       =      153
; NTEXT           INT       =       17
; TEXT            STRING    = Array[17]
; SOASTRS         STRING    = ' β-pine (0) β-car (1)  α-hum (2)  isoprene (3)  δ3-car (4) α-ced (5)  '
; SOASTRS2        STRING    = Array[6]
  endif

; *****
  print,'  '
  print,'  He SOA from BVOC'
  print,'  ',soastrs
  print,'  specify j (from 0 to 5)'
  read,j

  jval=j

; ***
   text2=string(soastrs2(jval))
;  lset=strcompress(text2)

; *****
; Output
   nlines=nwave

; Specify the indices
    rndat=fltarr(nwave)
    ridat=fltarr(nwave)
; Have as 0.0
    rnerr=fltarr(nwave)
    rierr=fltarr(nwave)
   for i=0,nwave-1 do begin
    rndat(i)=rn(i,j)
    ridat(i)=ri(i,j)
   endfor

; *****
     ntext=17
    text=strarr(ntext)

;           '1234567890123456789012345678901234567890123456789012345678901234567890'
    text(0)='                                                                      '
    text(1)='  Data: Real and imaginary indices of secondary organic aerosol (SOA) '
    text(2)='  from 315 to 650 nm produced by six BVOC compounds                   '
    text(3)='                                                                      '
    text(4)='  β-pinene, β-caryophyllene, α-humulene                               '
    text(5)='  isoprene, δ3-carene, α-cedrene                                      '
    text(6)='                                                                      '
    text(7)='  Reference: He Q, Tomaz S, Li C, Zhu M, Meidan D , Riva M,           '
    text(8)='  Laskin A, Brown S, George C, Wang X, Rudich Y                       '
    text(9)='  Optical properties of secondary organic aerosol produced by         '
    text(10)='  nitrate  radical oxidation of biogenic volatile organic compounds   '
    text(11)='  Env Sci Tech, 2021;55(5):2878-89                                    '
    text(12)='                                                                      '
    text(13)='  Email contact person: Y. Rudich (yinon.rudich@weizmann.ac.il)       '
    text(14)='                                                                      '
    text(15)='  Format: 153 real indices (2x,f8.2,2x,f10.4,6(2x,f5.3))              '
    text(16)='          153 imaginary indices (2x,f8.2,2x,f10.4,6(1x,e10.3))        '

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdhesoa: filnm ',filnm
    printf,iout,'  '
    printf,iout,'  rdhesoa: next ',ntext
    printf,iout,'  rdhesoa: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdhesoa: nlines ',nlines
   printf,iout,'  rdhesoa: soastrs2(j) ',soastrs2(j)
   printf,iout,'  rdhesoa: i,wcm,wavelength,rndat and ridat'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
