   pro rdhasenkopf_organic_haze,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; Note that there is only one wavelength (523 nm)

; ***
; The input netCDF file
  fil=strarr(1)
  fil='hasenkopf_organic_haze.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnwave=ncdf_varid(nc_id,'nwave')
  idncases=ncdf_varid(nc_id,'ncases')
  idwcmobs=ncdf_varid(nc_id,'wcmobs')
  idwmicobs=ncdf_varid(nc_id,'wmicobs')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idrnerr=ncdf_varid(nc_id,'rnerr')
  idrierr=ncdf_varid(nc_id,'rierr')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idncases,ncases
  ncdf_varget,nc_id,idnwave,nwave
  ncdf_varget,nc_id,idwcmobs,wcmobs
  ncdf_varget,nc_id,idwmicobs,wmicobs
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri
  ncdf_varget,nc_id,idrnerr,rnerr
  ncdf_varget,nc_id,idrierr,rierr

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
  for i=12,18 do begin  
   print,text(i)
  endfor

; Specify the set to work with
  print,' specify icase  0,1,2,3,4 or 5 '
  read,icase

; *****
; For the graphs (oops, but there is only one wavelength)
  text2=strarr(6)
  text2(0)=' Hasenkopf   Titan '
  text2(1)=' Hasenkopf   early Earth '
  text2(2)=' Khare (1984)  10% CH4 in N2 ' 
  text2(3)=' Ramirez (2002)  2% CH4 in N2 ' 
  text2(4)=' Tran (2003)  1.8% CH4 in N2 ' 
  text2(5)=' Vuitton (2009) 1.8% CH4 in N2 '

; *****
    nlines=nwave
   rndat=fltarr(nlines)
   ridat=fltarr(nlines)
   wcm=fltarr(nlines)
   wavelength=fltarr(nlines)

; **
; Specify the output values
   for i=0,nlines-1 do begin
    rndat(i)=rn(i,icase)
    ridat(i)=ri(i,icase)
    wcm(i)=wcmobs(i)
    wavelength(i)=wmicobs(i)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+text2(icase))

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdhasenkopf_organic_haze: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdhasenkopf_organic_haze: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
; Check and stop
   for i=0,nlines-1 do begin
    if (rndat(i) lt 0.0) then begin
     printf,iout,'  rdhasenkopf_organic_haze: i,wcm,wavelength,rndat and ridat'
     printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
     printf,iout,'  rdhasenkopf_organic_haze: rndat(i) lt 0, will stop'
     stop
    endif
   endfor

; ******
  return
  end


