   pro rdfangsoa,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rndat,ridat,rnerr,rierr

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file is filnm

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnlines=ncdf_varid(nc_id,'nlines')
  idnwave=ncdf_varid(nc_id,'nwave')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

  idtext=ncdf_varid(nc_id,'text')
  idsoastrs=ncdf_varid(nc_id,'soastrs')

  idn70=ncdf_varid(nc_id,'n70')
  idn10=ncdf_varid(nc_id,'n10')
  idn3=ncdf_varid(nc_id,'n3')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn10,n10
  ncdf_varget,nc_id,idn3,n3
  ncdf_varget,nc_id,idnlines,nlines
  ncdf_varget,nc_id,idnwave,nwave

; ncdf_varget,nc_id,idnweights,nweights
; ncdf_varget,nc_id,idwhno3,whno3

  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

  text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

  soastrs=strarr(n10,n3)
  ncdf_varget,nc_id,idsoastrs,soastrs
  soastrs=string(soastrs)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
   ihelp=0
  if (ihelp eq 1) then begin
   help,rn
   help,ri
   help,wcm
   help,wavelength
   help,nwave
   help,ntext
   help,text
   help,soastrs
; RN              FLOAT     = Array[409, 3]
; RI              FLOAT     = Array[409, 3]
; WCM             FLOAT     = Array[409]
; WAVELENGTH      FLOAT     = Array[409]
; NWAVE           INT       =      409
; NTEXT           INT       =       16
; TEXT            STRING    = Array[16]
; SOASTRS         STRING    = Array[3]
   stop
  endif

; *****
   soastrs=strarr(nlines)
;           '1234567890','1234567890','1234567890'
   soastrs=['OH 0.7   0','OH 5.5   1','OH 10.6  2']

  print,'  '
  print,'  Fang SOA '
  print,'  soastrs ',soastrs
  print,'  specify j (from 0 to 2)'
  read,j

  jval=j

; ***
   text2=string(soastrs(j))
;  lset=strcompress(lstrn+text2)

; *****
; Output
   nlines=nwave

; Specify the indices
    rndat=fltarr(nwave)
    ridat=fltarr(nwave)
; have as 0.0
    rnerr=fltarr(nwave)
    rierr=fltarr(nwave)
   for i=0,nwave-1 do begin
    rndat(i)=rn(i,j)
    ridat(i)=ri(i,j)
   endfor

; *****
     ntext=16
    text=strarr(ntext)
    n70=70
    n10=10

;           '1234567890123456789012345678901234567890123456789012345678901234567890'
    text(0)='                                                                      '
    text(1)='  Data: Complex refractive index of secondary organic aerosols        '
    text(2)='  from 300 to 450 nm                                                  '
    text(3)='                                                                      '
    text(4)='  Reference: Fang Z, Li C, He Q, Czech H, Gröger T, Zeng J, Fang H,   '
    text(5)='  Xiao S, Pardo M, Hartner E, and Meidan D, Wang X, Zimmermann R      '
    text(6)='  Laskin A, Rudich Y                                                  '
    text(7)='  Secondary organic aerosols produced from photochemical oxidation    '
    text(8)='  of secondarily evaporated biomass burning organic gases: Chemical   '
    text(9)='  composition, toxicity, optical properties, and climate effect       '
    text(10)='  Env Int, 2021;157:106801                                            '

; Fang, Z., Li, C., He, Q., Czech, H., Gröger, T., Zeng, J., Fang, H., Xiao, S., Pardo, M., Hartner, E. and Meidan, D., 2021. Secondary organic aerosols produced from photochemical oxidation of secondarily evaporated biomass burning organic gases: Chemical composition, toxicity, optical properties, and climate effect. Environment international, 157, p.106801.

    text(11)='                                                                      '
    text(12)='  Email contact person: Y. Rudich (yinon.rudich@weizmann.ac.il)       '
    text(13)='                                                                      '
    text(14)='  Format: 409 real indices (2x,f8.2,2x,f10.4,3(2x,f5.3))              '
    text(15)='          409 imaginary indices (2x,f8.2,2x,f10.4,3(1x,e10.3))        '

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdfangsoa: filnm ',filnm
    printf,iout,'  '
    printf,iout,'  rdfangsoa: next ',ntext
    printf,iout,'  rdfangsoa: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdfangsoa: nwave ',nwave
   printf,iout,'  rdfangsoa: soastrs(j) ',soastrs(j)
   printf,iout,'  rdfangsoa: i,wcm,wavelength,rndat and ridat'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
